@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-money-check-alt"></i> Debit Voucher - {{ $voucher->voucher_no }}</h3>
        <div style="display: flex; gap: 0.5rem;">
            <a href="{{ route('vouchers.debit.print', $voucher) }}" class="btn btn-outline" target="_blank">
                <i class="fas fa-print"></i> Print
            </a>
            <a href="{{ route('vouchers.debit.index') }}" class="btn btn-outline">
                <i class="fas fa-arrow-left"></i> Back
            </a>
        </div>
    </div>
    <div class="card-body">
        <!-- Voucher Header Info -->
        <div class="form-row">
            <div class="form-group" style="flex: 0 0 200px;">
                <label class="form-label text-muted">Voucher No.</label>
                <div style="font-size: 1.25rem; font-weight: 600; color: var(--danger-color);">
                    {{ $voucher->voucher_no }}
                </div>
            </div>
            <div class="form-group" style="flex: 0 0 150px;">
                <label class="form-label text-muted">Date</label>
                <div style="font-size: 1rem; font-weight: 500;">
                    {{ $voucher->date->format('d-M-Y') }}
                </div>
            </div>
            <div class="form-group" style="flex: 0 0 200px;">
                <label class="form-label text-muted">Amount</label>
                <div style="font-size: 1.5rem; font-weight: 700; color: var(--danger-color);">
                    Rs. {{ number_format($voucher->amount, 2) }}
                </div>
            </div>
            <div class="form-group" style="flex: 1;">
                <label class="form-label text-muted">Type</label>
                <div>
                    <span class="badge badge-danger" style="font-size: 0.875rem;">
                        <i class="fas fa-money-check-alt"></i> {{ $voucher->type }} VOUCHER (PAYMENT)
                    </span>
                </div>
            </div>
        </div>

        @if($voucher->narration)
        <div class="form-group mt-3">
            <label class="form-label text-muted">Narration</label>
            <div style="padding: 0.75rem; background: var(--light-bg); border-radius: var(--border-radius); border: 1px solid var(--border-color);">
                {{ $voucher->narration }}
            </div>
        </div>
        @endif

        <!-- Voucher Entries -->
        <div class="card mt-4" style="border: 1px solid var(--border-color);">
            <div class="card-header" style="background: var(--light-bg); padding: 0.75rem 1rem;">
                <h4 style="font-size: 0.9375rem; font-weight: 600; margin: 0;">
                    <i class="fas fa-list"></i> Voucher Entries
                </h4>
            </div>
            <div class="card-body" style="padding: 0;">
                <table>
                    <thead>
                        <tr>
                            <th>Account</th>
                            <th style="width: 100px;">Code</th>
                            <th class="text-right" style="width: 150px;">Debit</th>
                            <th class="text-right" style="width: 150px;">Credit</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($voucher->entries as $entry)
                        <tr>
                            <td>
                                <a href="{{ route('accounts.show', $entry->account) }}">{{ $entry->account->name }}</a>
                            </td>
                            <td>{{ $entry->account->code }}</td>
                            <td class="text-right">
                                @if($entry->debit > 0)
                                    <strong class="text-success">Rs. {{ number_format($entry->debit, 2) }}</strong>
                                @else
                                    -
                                @endif
                            </td>
                            <td class="text-right">
                                @if($entry->credit > 0)
                                    <strong class="text-danger">Rs. {{ number_format($entry->credit, 2) }}</strong>
                                @else
                                    -
                                @endif
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr style="background: var(--light-bg);">
                            <td colspan="2" class="text-right"><strong>Total:</strong></td>
                            <td class="text-right"><strong>Rs. {{ number_format($voucher->entries->sum('debit'), 2) }}</strong></td>
                            <td class="text-right"><strong>Rs. {{ number_format($voucher->entries->sum('credit'), 2) }}</strong></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>

        <!-- Meta Info -->
        <div style="margin-top: 1.5rem; font-size: 0.875rem; color: var(--secondary-color);">
            <i class="fas fa-user"></i> Created by: {{ $voucher->user->name ?? 'System' }} |
            <i class="fas fa-clock"></i> {{ $voucher->created_at->format('d-M-Y h:i A') }}
        </div>

        <!-- Action Buttons -->
        <div style="display: flex; gap: 0.5rem; margin-top: 1.5rem; padding-top: 1rem; border-top: 1px solid var(--border-color);">
            <a href="{{ route('vouchers.debit.print', $voucher) }}" class="btn btn-outline" target="_blank">
                <i class="fas fa-print"></i> Print Voucher
            </a>
            <form action="{{ route('vouchers.debit.destroy', $voucher) }}" method="POST" 
                  onsubmit="return confirm('Are you sure you want to delete this voucher? This will reverse ledger entries.');"
                  style="display: inline;">
                @csrf
                @method('DELETE')
                <button type="submit" class="btn btn-outline" style="color: var(--danger-color);">
                    <i class="fas fa-trash"></i> Delete
                </button>
            </form>
            <a href="{{ route('vouchers.debit.create') }}" class="btn btn-outline" style="margin-left: auto;">
                <i class="fas fa-plus"></i> New Debit Voucher
            </a>
        </div>
    </div>
</div>
@endsection
