<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Debit Voucher - {{ $voucher->voucher_no }}</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            font-size: 12pt;
            line-height: 1.4;
            color: #333;
        }
        .voucher-container {
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }
        .voucher-header {
            text-align: center;
            border-bottom: 2px solid #333;
            padding-bottom: 15px;
            margin-bottom: 20px;
        }
        .company-name {
            font-size: 24pt;
            font-weight: bold;
            color: #333;
            text-transform: uppercase;
            letter-spacing: 2px;
        }
        .company-tagline {
            font-size: 10pt;
            color: #666;
            margin-top: 5px;
        }
        .voucher-title {
            background: #dc3545;
            color: #fff;
            padding: 8px 20px;
            font-size: 14pt;
            font-weight: bold;
            display: inline-block;
            margin-top: 15px;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        .voucher-info {
            display: flex;
            justify-content: space-between;
            margin-bottom: 20px;
            padding: 10px 0;
            border-bottom: 1px solid #ddd;
        }
        .info-group {
            text-align: left;
        }
        .info-group.right {
            text-align: right;
        }
        .info-label {
            font-size: 9pt;
            color: #666;
            text-transform: uppercase;
        }
        .info-value {
            font-size: 14pt;
            font-weight: bold;
            color: #333;
        }
        .amount-box {
            background: #f8f9fa;
            border: 2px solid #dc3545;
            padding: 15px;
            text-align: center;
            margin: 20px 0;
        }
        .amount-label {
            font-size: 10pt;
            color: #666;
            text-transform: uppercase;
        }
        .amount-value {
            font-size: 24pt;
            font-weight: bold;
            color: #dc3545;
        }
        .amount-words {
            font-size: 11pt;
            font-style: italic;
            color: #555;
            margin-top: 5px;
        }
        .entries-table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }
        .entries-table th,
        .entries-table td {
            padding: 10px;
            border: 1px solid #ddd;
            text-align: left;
        }
        .entries-table th {
            background: #f8f9fa;
            font-weight: 600;
            text-transform: uppercase;
            font-size: 9pt;
        }
        .entries-table .text-right {
            text-align: right;
        }
        .entries-table tfoot td {
            background: #f8f9fa;
            font-weight: bold;
        }
        .narration-box {
            background: #f8f9fa;
            padding: 15px;
            margin: 20px 0;
            border-left: 4px solid #dc3545;
        }
        .narration-label {
            font-size: 9pt;
            color: #666;
            text-transform: uppercase;
            margin-bottom: 5px;
        }
        .signatures {
            display: flex;
            justify-content: space-between;
            margin-top: 60px;
            padding-top: 20px;
        }
        .signature-box {
            text-align: center;
            width: 200px;
        }
        .signature-line {
            border-top: 1px solid #333;
            margin-top: 50px;
            padding-top: 5px;
        }
        .signature-label {
            font-size: 10pt;
            color: #666;
        }
        .footer {
            text-align: center;
            margin-top: 30px;
            padding-top: 15px;
            border-top: 1px solid #ddd;
            font-size: 9pt;
            color: #999;
        }
        @media print {
            body {
                print-color-adjust: exact;
                -webkit-print-color-adjust: exact;
            }
            .voucher-container {
                padding: 0;
            }
            .no-print {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="voucher-container">
        <!-- Print Button -->
        <div class="no-print" style="text-align: right; margin-bottom: 20px;">
            <button onclick="window.print()" style="padding: 10px 20px; background: #dc3545; color: #fff; border: none; cursor: pointer; font-size: 14px;">
                🖨️ Print Voucher
            </button>
            <button onclick="window.close()" style="padding: 10px 20px; background: #6c757d; color: #fff; border: none; cursor: pointer; font-size: 14px; margin-left: 10px;">
                ✕ Close
            </button>
        </div>

        <!-- Header -->
        <div class="voucher-header">
            <div class="company-name">{{ $settings['company_name'] ?? 'USMAN BILAL Enterprises' }}</div>
            <div class="company-tagline">{{ $settings['company_address'] ?? 'Cotton Waste Processors & Dealers' }}</div>
            <div class="voucher-title">Debit Voucher (Payment)</div>
        </div>

        <!-- Voucher Info -->
        <div class="voucher-info">
            <div class="info-group">
                <div class="info-label">Voucher No.</div>
                <div class="info-value">{{ $voucher->voucher_no }}</div>
            </div>
            <div class="info-group right">
                <div class="info-label">Date</div>
                <div class="info-value">{{ $voucher->date->format('d-M-Y') }}</div>
            </div>
        </div>

        <!-- Amount Box -->
        <div class="amount-box">
            <div class="amount-label">Amount Paid</div>
            <div class="amount-value">Rs. {{ number_format($voucher->amount, 2) }}</div>
            <div class="amount-words">{{ ucwords(numberToWords($voucher->amount)) }} Rupees Only</div>
        </div>

        <!-- Entries Table -->
        <table class="entries-table">
            <thead>
                <tr>
                    <th>Account</th>
                    <th>Code</th>
                    <th class="text-right">Debit (Rs.)</th>
                    <th class="text-right">Credit (Rs.)</th>
                </tr>
            </thead>
            <tbody>
                @foreach($voucher->entries as $entry)
                <tr>
                    <td>{{ $entry->account->name }}</td>
                    <td>{{ $entry->account->code }}</td>
                    <td class="text-right">{{ $entry->debit > 0 ? number_format($entry->debit, 2) : '-' }}</td>
                    <td class="text-right">{{ $entry->credit > 0 ? number_format($entry->credit, 2) : '-' }}</td>
                </tr>
                @endforeach
            </tbody>
            <tfoot>
                <tr>
                    <td colspan="2" class="text-right">Total:</td>
                    <td class="text-right">{{ number_format($voucher->entries->sum('debit'), 2) }}</td>
                    <td class="text-right">{{ number_format($voucher->entries->sum('credit'), 2) }}</td>
                </tr>
            </tfoot>
        </table>

        <!-- Narration -->
        @if($voucher->narration)
        <div class="narration-box">
            <div class="narration-label">Narration / Description</div>
            <div>{{ $voucher->narration }}</div>
        </div>
        @endif

        <!-- Signatures -->
        <div class="signatures">
            <div class="signature-box">
                <div class="signature-line">Paid To</div>
            </div>
            <div class="signature-box">
                <div class="signature-line">Accountant</div>
            </div>
            <div class="signature-box">
                <div class="signature-line">Authorized Signatory</div>
            </div>
        </div>

        <!-- Footer -->
        <div class="footer">
            Printed on: {{ now()->format('d-M-Y h:i A') }} | 
            User: {{ auth()->user()->name ?? 'System' }} |
            This is a computer-generated document
        </div>
    </div>
</body>
</html>

@php
function numberToWords($number) {
    $ones = ['', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'ten',
             'eleven', 'twelve', 'thirteen', 'fourteen', 'fifteen', 'sixteen', 'seventeen', 'eighteen', 'nineteen'];
    $tens = ['', '', 'twenty', 'thirty', 'forty', 'fifty', 'sixty', 'seventy', 'eighty', 'ninety'];
    
    $number = (int)$number;
    if ($number == 0) return 'zero';
    
    $words = '';
    
    if ($number >= 10000000) {
        $words .= numberToWords(floor($number / 10000000)) . ' crore ';
        $number %= 10000000;
    }
    if ($number >= 100000) {
        $words .= numberToWords(floor($number / 100000)) . ' lakh ';
        $number %= 100000;
    }
    if ($number >= 1000) {
        $words .= numberToWords(floor($number / 1000)) . ' thousand ';
        $number %= 1000;
    }
    if ($number >= 100) {
        $words .= $ones[floor($number / 100)] . ' hundred ';
        $number %= 100;
    }
    if ($number >= 20) {
        $words .= $tens[floor($number / 10)] . ' ';
        $number %= 10;
    }
    if ($number > 0) {
        $words .= $ones[$number] . ' ';
    }
    
    return trim($words);
}
@endphp
