@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-money-check-alt"></i> New Debit Voucher (Payment)</h3>
        <a href="{{ route('vouchers.debit.index') }}" class="btn btn-outline">
            <i class="fas fa-arrow-left"></i> Back to List
        </a>
    </div>
    <div class="card-body">
        @if($errors->any())
        <div class="alert alert-danger">
            <ul style="margin: 0; padding-left: 1rem;">
                @foreach($errors->all() as $error)
                <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
        @endif

        <form action="{{ route('vouchers.debit.store') }}" method="POST">
            @csrf
            
            <div class="form-row">
                <div class="form-group" style="flex: 0 0 180px;">
                    <label class="form-label">Voucher No. <span class="text-danger">*</span></label>
                    <input type="text" name="voucher_no" class="form-control" 
                           value="{{ old('voucher_no', $nextVoucherNo) }}" readonly 
                           style="background: #f0f0f0; font-weight: bold;">
                </div>
                <div class="form-group" style="flex: 0 0 180px;">
                    <label class="form-label">Date <span class="text-danger">*</span></label>
                    <input type="date" name="date" class="form-control" 
                           value="{{ old('date', date('Y-m-d')) }}" required>
                </div>
                <div class="form-group" style="flex: 0 0 200px;">
                    <label class="form-label">Amount <span class="text-danger">*</span></label>
                    <input type="number" name="amount" id="amount" class="form-control" 
                           value="{{ old('amount') }}" required min="0.01" step="0.01"
                           style="font-size: 1.125rem; font-weight: bold;">
                </div>
            </div>

            <div class="form-row">
                <div class="form-group" style="flex: 1;">
                    <label class="form-label">Account (Debit - Pay To) <span class="text-danger">*</span></label>
                    <select name="account_id" id="account_id" class="form-control" required>
                        <option value="">-- Select Account to Debit --</option>
                        @foreach($accounts as $account)
                        <option value="{{ $account->id }}" 
                                data-code="{{ $account->code }}"
                                {{ old('account_id') == $account->id ? 'selected' : '' }}>
                            {{ $account->code }} - {{ $account->name }} ({{ $account->type }})
                        </option>
                        @endforeach
                    </select>
                    <small class="text-muted">This account will be DEBITED (expenses, assets, receivables)</small>
                </div>
                <div class="form-group" style="flex: 1;">
                    <label class="form-label">Cash/Bank Account (Credit - Pay From) <span class="text-danger">*</span></label>
                    <select name="cash_bank_id" id="cash_bank_id" class="form-control" required>
                        <option value="">-- Select Cash/Bank Account --</option>
                        @foreach($cashBankAccounts as $account)
                        <option value="{{ $account->id }}" 
                                data-code="{{ $account->code }}"
                                {{ old('cash_bank_id') == $account->id ? 'selected' : '' }}>
                            {{ $account->code }} - {{ $account->name }}
                        </option>
                        @endforeach
                    </select>
                    <small class="text-muted">This account will be CREDITED (reduced)</small>
                </div>
            </div>

            <div class="form-group">
                <label class="form-label">Narration</label>
                <textarea name="narration" class="form-control" rows="2" 
                          placeholder="Description of payment...">{{ old('narration') }}</textarea>
            </div>

            <!-- Ledger Entry Preview -->
            <div class="card mt-4" style="border: 1px solid var(--border-color); background: #f8f9fa;">
                <div class="card-header" style="background: var(--warning-color); color: #000; padding: 0.5rem 1rem;">
                    <h4 style="font-size: 0.875rem; font-weight: 600; margin: 0;">
                        <i class="fas fa-book"></i> Ledger Entry Preview
                    </h4>
                </div>
                <div class="card-body" style="padding: 0;">
                    <table>
                        <thead>
                            <tr>
                                <th>Account</th>
                                <th class="text-right" style="width: 150px;">Debit</th>
                                <th class="text-right" style="width: 150px;">Credit</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td id="debit_account_name">Select account to debit...</td>
                                <td class="text-right"><strong id="debit_amount" class="text-success">0.00</strong></td>
                                <td class="text-right">-</td>
                            </tr>
                            <tr>
                                <td id="credit_account_name">Select cash/bank account...</td>
                                <td class="text-right">-</td>
                                <td class="text-right"><strong id="credit_amount" class="text-danger">0.00</strong></td>
                            </tr>
                        </tbody>
                        <tfoot>
                            <tr style="background: #e9ecef;">
                                <td class="text-right"><strong>Total:</strong></td>
                                <td class="text-right"><strong id="total_debit">0.00</strong></td>
                                <td class="text-right"><strong id="total_credit">0.00</strong></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>

            <div style="display: flex; gap: 0.5rem; margin-top: 1.5rem;">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Save Debit Voucher
                </button>
                <a href="{{ route('vouchers.debit.index') }}" class="btn btn-outline">
                    <i class="fas fa-times"></i> Cancel
                </a>
            </div>
        </form>

        <!-- Info Box -->
        <div class="alert alert-warning mt-4">
            <h4 style="font-size: 0.9375rem; margin-bottom: 0.5rem;">
                <i class="fas fa-info-circle"></i> Debit Voucher (Payment)
            </h4>
            <p style="margin: 0; font-size: 0.875rem;">
                <strong>Use this voucher when making payments:</strong> supplier payments, expense payments, 
                loan repayments, advance payments, etc. The selected account (expense/asset) will be 
                DEBITED and Cash/Bank will be CREDITED.
            </p>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const amountField = document.getElementById('amount');
    const accountSelect = document.getElementById('account_id');
    const cashBankSelect = document.getElementById('cash_bank_id');
    
    function updatePreview() {
        const amount = parseFloat(amountField.value) || 0;
        const accountOption = accountSelect.options[accountSelect.selectedIndex];
        const cashBankOption = cashBankSelect.options[cashBankSelect.selectedIndex];
        
        document.getElementById('debit_amount').textContent = amount.toFixed(2);
        document.getElementById('credit_amount').textContent = amount.toFixed(2);
        document.getElementById('total_debit').textContent = amount.toFixed(2);
        document.getElementById('total_credit').textContent = amount.toFixed(2);
        
        if (accountSelect.value) {
            document.getElementById('debit_account_name').textContent = accountOption.text;
        } else {
            document.getElementById('debit_account_name').textContent = 'Select account to debit...';
        }
        
        if (cashBankSelect.value) {
            document.getElementById('credit_account_name').textContent = cashBankOption.text;
        } else {
            document.getElementById('credit_account_name').textContent = 'Select cash/bank account...';
        }
    }
    
    amountField.addEventListener('input', updatePreview);
    accountSelect.addEventListener('change', updatePreview);
    cashBankSelect.addEventListener('change', updatePreview);
    
    updatePreview();
});
</script>
@endsection
