@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-calendar-alt"></i> Financial Year Settings</h3>
        <a href="{{ route('settings.index') }}" class="btn btn-outline">
            <i class="fas fa-arrow-left"></i> Back to Settings
        </a>
    </div>
    <div class="card-body">
        @if(session('success'))
            <div style="background-color: #d4edda; border: 1px solid #c3e6cb; color: #155724; padding: 1rem; border-radius: 4px; margin-bottom: 1rem;">
                <i class="fas fa-check-circle"></i> {{ session('success') }}
            </div>
        @endif

        <form action="{{ route('settings.financial-year.update') }}" method="POST">
            @csrf
            @method('PUT')

            <!-- Current Financial Year Info -->
            <div style="background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%); padding: 1.5rem; border-radius: 12px; color: white; margin-bottom: 1.5rem;">
                <h4 style="margin: 0 0 1rem 0;"><i class="fas fa-info-circle"></i> Current Financial Year</h4>
                <div class="form-row" style="justify-content: space-around;">
                    <div style="text-align: center;">
                        <div style="font-size: 0.875rem; opacity: 0.9;">Start Date</div>
                        <div style="font-size: 1.5rem; font-weight: 700;">{{ \Carbon\Carbon::parse($financialYear->start_date)->format('d-M-Y') }}</div>
                    </div>
                    <div style="font-size: 2rem; opacity: 0.5;">→</div>
                    <div style="text-align: center;">
                        <div style="font-size: 0.875rem; opacity: 0.9;">End Date</div>
                        <div style="font-size: 1.5rem; font-weight: 700;">{{ \Carbon\Carbon::parse($financialYear->end_date)->format('d-M-Y') }}</div>
                    </div>
                    <div style="text-align: center; background: rgba(255,255,255,0.2); padding: 0.75rem 1.5rem; border-radius: 8px;">
                        <div style="font-size: 0.875rem; opacity: 0.9;">Duration</div>
                        <div style="font-size: 1.25rem; font-weight: 700;">
                            {{ \Carbon\Carbon::parse($financialYear->start_date)->diffInMonths(\Carbon\Carbon::parse($financialYear->end_date)) }} Months
                        </div>
                    </div>
                </div>
            </div>

            <div class="form-row">
                <div class="form-group" style="flex: 1;">
                    <label class="form-label" for="start_date">Financial Year Start Date <span class="text-danger">*</span></label>
                    <input type="date" class="form-control" id="start_date" name="start_date" value="{{ old('start_date', $financialYear->start_date) }}" required>
                    @error('start_date')
                        <div class="text-danger" style="font-size: 0.85rem;">{{ $message }}</div>
                    @enderror
                    <small class="text-muted">Usually July 1st (Pakistan) or January 1st</small>
                </div>
                <div class="form-group" style="flex: 1;">
                    <label class="form-label" for="end_date">Financial Year End Date <span class="text-danger">*</span></label>
                    <input type="date" class="form-control" id="end_date" name="end_date" value="{{ old('end_date', $financialYear->end_date) }}" required>
                    @error('end_date')
                        <div class="text-danger" style="font-size: 0.85rem;">{{ $message }}</div>
                    @enderror
                    <small class="text-muted">Usually June 30th (Pakistan) or December 31st</small>
                </div>
            </div>

            <!-- Quick Presets -->
            <div style="background: #f8f9fa; padding: 1rem; border-radius: 8px; margin-bottom: 1.5rem; border: 1px solid var(--border-color);">
                <label class="form-label"><i class="fas fa-magic"></i> Quick Presets</label>
                <div style="display: flex; gap: 0.5rem; flex-wrap: wrap;">
                    <button type="button" class="btn btn-outline preset-btn" data-start="2025-07-01" data-end="2026-06-30">
                        July 2025 - June 2026
                    </button>
                    <button type="button" class="btn btn-outline preset-btn" data-start="2026-01-01" data-end="2026-12-31">
                        Jan 2026 - Dec 2026
                    </button>
                    <button type="button" class="btn btn-outline preset-btn" data-start="2026-07-01" data-end="2027-06-30">
                        July 2026 - June 2027
                    </button>
                </div>
            </div>

            <div style="background: #fff3cd; border: 1px solid #ffc107; padding: 1rem; border-radius: 8px; margin-bottom: 1.5rem;">
                <strong><i class="fas fa-exclamation-triangle text-warning"></i> Important:</strong>
                <p style="margin: 0.5rem 0 0 0;">Changing the financial year dates will affect all reports and trial balance calculations. Make sure to close the current year properly before changing these settings.</p>
            </div>

            <div style="display: flex; gap: 0.5rem; margin-top: 1.5rem; padding-top: 1rem; border-top: 1px solid var(--border-color);">
                <button type="submit" class="btn btn-success">
                    <i class="fas fa-save"></i> Save Financial Year Settings
                </button>
                <a href="{{ route('settings.index') }}" class="btn btn-outline">
                    <i class="fas fa-times"></i> Cancel
                </a>
            </div>
        </form>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Quick preset buttons
    document.querySelectorAll('.preset-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            document.getElementById('start_date').value = this.dataset.start;
            document.getElementById('end_date').value = this.dataset.end;
        });
    });
});
</script>
@endsection
