@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-file-invoice"></i> Sale Bill - {{ $sale->bill_no }}</h3>
        <div style="display: flex; gap: 0.5rem;">
            <a href="{{ route('sales.print', $sale) }}" class="btn btn-outline" target="_blank">
                <i class="fas fa-print"></i> Print
            </a>
            <a href="{{ route('sales.edit', $sale) }}" class="btn btn-secondary">
                <i class="fas fa-edit"></i> Edit
            </a>
            <a href="{{ route('sales.index') }}" class="btn btn-outline">
                <i class="fas fa-arrow-left"></i> Back
            </a>
        </div>
    </div>
    <div class="card-body">
        <!-- Bill Header Info -->
        <div class="form-row">
            <div class="form-group" style="flex: 0 0 200px;">
                <label class="form-label text-muted">Bill No.</label>
                <div style="font-size: 1.25rem; font-weight: 600; color: var(--success-color);">
                    {{ $sale->bill_no }}
                </div>
            </div>
            <div class="form-group" style="flex: 0 0 150px;">
                <label class="form-label text-muted">Date</label>
                <div style="font-size: 1rem; font-weight: 500;">
                    {{ $sale->date->format('d-M-Y') }}
                </div>
            </div>
            <div class="form-group" style="flex: 1;">
                <label class="form-label text-muted">Customer</label>
                <div style="font-size: 1rem; font-weight: 500;">
                    <a href="{{ route('parties.show', $sale->party) }}" style="color: var(--success-color);">
                        {{ $sale->party->name }}
                    </a>
                    <small class="text-muted">({{ $sale->party->code }})</small>
                </div>
            </div>
            @if($sale->ref_no)
            <div class="form-group" style="flex: 0 0 150px;">
                <label class="form-label text-muted">Reference No.</label>
                <div style="font-size: 1rem;">{{ $sale->ref_no }}</div>
            </div>
            @endif
        </div>

        <!-- Items Table -->
        <div class="card mt-3" style="border: 1px solid var(--border-color);">
            <div class="card-header" style="background: var(--light-bg); padding: 0.75rem 1rem;">
                <h4 style="font-size: 0.9375rem; font-weight: 600; margin: 0;">
                    <i class="fas fa-list"></i> Sale Items
                </h4>
            </div>
            <div class="card-body" style="padding: 0;">
                <table>
                    <thead>
                        <tr>
                            <th style="width: 50px;">#</th>
                            <th>Item</th>
                            <th style="width: 100px;">Code</th>
                            <th class="text-right" style="width: 100px;">Quantity</th>
                            <th style="width: 80px;">Unit</th>
                            <th class="text-right" style="width: 120px;">Rate</th>
                            <th class="text-right" style="width: 150px;">Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($sale->items as $index => $item)
                        <tr>
                            <td class="text-center">{{ $index + 1 }}</td>
                            <td>
                                <a href="{{ route('items.show', $item->item) }}" style="color: var(--text-color);">
                                    {{ $item->item->name }}
                                </a>
                            </td>
                            <td>{{ $item->item->code }}</td>
                            <td class="text-right">{{ number_format($item->quantity, 2) }}</td>
                            <td>{{ $item->item->unit }}</td>
                            <td class="text-right">{{ number_format($item->rate, 2) }}</td>
                            <td class="text-right" style="font-weight: 500;">{{ number_format($item->amount, 2) }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr style="background: var(--light-bg);">
                            <td colspan="3" class="text-right"><strong>Total Items: {{ $sale->items->count() }}</strong></td>
                            <td class="text-right"><strong>{{ number_format($sale->items->sum('quantity'), 2) }}</strong></td>
                            <td colspan="2"></td>
                            <td class="text-right" style="font-size: 1.1rem;"><strong>Rs. {{ number_format($sale->sub_total, 2) }}</strong></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>

        <!-- Bill Summary -->
        <div class="form-row mt-4">
            <div class="form-group" style="flex: 1;">
                @if($sale->narration)
                <label class="form-label text-muted">Remarks</label>
                <div style="padding: 0.75rem; background: var(--light-bg); border-radius: var(--border-radius); border: 1px solid var(--border-color);">
                    {{ $sale->narration }}
                </div>
                @endif
                
                <div style="margin-top: 1rem;">
                    <label class="form-label text-muted">Transaction Info</label>
                    <div style="font-size: 0.875rem; color: var(--secondary-color);">
                        <i class="fas fa-user"></i> Created by: {{ $sale->user->name ?? 'System' }}<br>
                        <i class="fas fa-clock"></i> Created: {{ $sale->created_at->format('d-M-Y h:i A') }}<br>
                        @if($sale->updated_at != $sale->created_at)
                        <i class="fas fa-edit"></i> Last Updated: {{ $sale->updated_at->format('d-M-Y h:i A') }}
                        @endif
                    </div>
                </div>
            </div>

            <div style="flex: 0 0 350px;">
                <table style="width: 100%; border: 1px solid var(--border-color); border-radius: var(--border-radius);">
                    <tr>
                        <td style="padding: 0.75rem 1rem; border-bottom: 1px solid var(--border-color); text-align: right;">
                            Gross Amount:
                        </td>
                        <td style="padding: 0.75rem 1rem; border-bottom: 1px solid var(--border-color); text-align: right; width: 150px;">
                            <strong>Rs. {{ number_format($sale->sub_total, 2) }}</strong>
                        </td>
                    </tr>
                    <tr>
                        <td style="padding: 0.75rem 1rem; border-bottom: 1px solid var(--border-color); text-align: right;">
                            Discount:
                        </td>
                        <td style="padding: 0.75rem 1rem; border-bottom: 1px solid var(--border-color); text-align: right; color: var(--danger-color);">
                            <strong>- Rs. {{ number_format($sale->discount_amount, 2) }}</strong>
                        </td>
                    </tr>
                    <tr style="background: var(--success-color); color: white;">
                        <td style="padding: 1rem; text-align: right; font-size: 1.125rem;">
                            <strong>Net Amount:</strong>
                        </td>
                        <td style="padding: 1rem; text-align: right; font-size: 1.25rem;">
                            <strong>Rs. {{ number_format($sale->total_amount, 2) }}</strong>
                        </td>
                    </tr>
                </table>
            </div>
        </div>

        <!-- Ledger Entries -->
        @if($sale->transactions->count() > 0)
        <div class="card mt-4" style="border: 1px solid var(--border-color);">
            <div class="card-header" style="background: var(--light-bg); padding: 0.75rem 1rem;">
                <h4 style="font-size: 0.9375rem; font-weight: 600; margin: 0;">
                    <i class="fas fa-book"></i> Ledger Entries
                </h4>
            </div>
            <div class="card-body" style="padding: 0;">
                <table>
                    <thead>
                        <tr>
                            <th>Account</th>
                            <th class="text-right" style="width: 150px;">Debit</th>
                            <th class="text-right" style="width: 150px;">Credit</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($sale->transactions as $transaction)
                        <tr>
                            <td>
                                <a href="{{ route('accounts.show', $transaction->account) }}">
                                    {{ $transaction->account->name }}
                                </a>
                                <small class="text-muted">({{ $transaction->account->code }})</small>
                            </td>
                            <td class="text-right">
                                @if($transaction->debit > 0)
                                    <span style="color: var(--success-color);">Rs. {{ number_format($transaction->debit, 2) }}</span>
                                @else
                                    -
                                @endif
                            </td>
                            <td class="text-right">
                                @if($transaction->credit > 0)
                                    <span style="color: var(--danger-color);">Rs. {{ number_format($transaction->credit, 2) }}</span>
                                @else
                                    -
                                @endif
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        @endif

        <!-- Action Buttons -->
        <div style="display: flex; gap: 0.5rem; margin-top: 1.5rem; padding-top: 1rem; border-top: 1px solid var(--border-color);">
            <a href="{{ route('sales.edit', $sale) }}" class="btn btn-secondary">
                <i class="fas fa-edit"></i> Edit Bill
            </a>
            <a href="{{ route('sales.print', $sale) }}" class="btn btn-outline" target="_blank">
                <i class="fas fa-print"></i> Print Bill
            </a>
            <form action="{{ route('sales.destroy', $sale) }}" method="POST" 
                  onsubmit="return confirm('Are you sure you want to delete this sale bill? This will also reverse stock and ledger entries.');"
                  style="display: inline;">
                @csrf
                @method('DELETE')
                <button type="submit" class="btn btn-outline" style="color: var(--danger-color);">
                    <i class="fas fa-trash"></i> Delete
                </button>
            </form>
            <a href="{{ route('sales.create') }}" class="btn btn-outline" style="margin-left: auto;">
                <i class="fas fa-plus"></i> New Sale
            </a>
        </div>
    </div>
</div>
@endsection
