@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-receipt"></i> Sale Bills</h3>
        <a href="{{ route('sales.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> New Sale Bill
        </a>
    </div>
    <div class="card-body">
        @if(session('success'))
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i> {{ session('success') }}
            </div>
        @endif
        
        @if(session('error'))
            <div class="alert alert-danger">
                <i class="fas fa-exclamation-circle"></i> {{ session('error') }}
            </div>
        @endif

        <!-- Filters -->
        <form action="{{ route('sales.index') }}" method="GET">
            <div class="form-row mb-4">
                <div class="form-group" style="flex: 0 0 150px;">
                    <label class="form-label">From Date</label>
                    <input type="date" class="form-control" name="from_date" value="{{ request('from_date', date('Y-m-01')) }}">
                </div>
                <div class="form-group" style="flex: 0 0 150px;">
                    <label class="form-label">To Date</label>
                    <input type="date" class="form-control" name="to_date" value="{{ request('to_date', date('Y-m-d')) }}">
                </div>
                <div class="form-group" style="flex: 1;">
                    <label class="form-label">Customer</label>
                    <select class="form-control" name="party_id">
                        <option value="">All Customers</option>
                        @foreach($parties as $party)
                            <option value="{{ $party->id }}" {{ request('party_id') == $party->id ? 'selected' : '' }}>
                                {{ $party->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="form-group" style="flex: 0 0 200px;">
                    <label class="form-label">Search</label>
                    <input type="text" class="form-control" name="search" value="{{ request('search') }}" placeholder="Bill No / Ref No...">
                </div>
                <div class="form-group" style="flex: 0 0 100px; display: flex; align-items: flex-end;">
                    <button type="submit" class="btn btn-primary" style="width: 100%;">
                        <i class="fas fa-search"></i> Search
                    </button>
                </div>
            </div>
        </form>

        <div class="table-responsive">
            <table>
                <thead>
                    <tr>
                        <th>Bill No.</th>
                        <th>Date</th>
                        <th>Customer</th>
                        <th>Ref. No.</th>
                        <th class="text-right">Gross</th>
                        <th class="text-right">Disc.</th>
                        <th class="text-right">Net Amount</th>
                        <th class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($sales as $sale)
                        <tr>
                            <td>
                                <a href="{{ route('sales.show', $sale) }}" style="font-weight: 600; color: var(--primary-color);">
                                    {{ $sale->bill_no }}
                                </a>
                            </td>
                            <td>{{ $sale->date->format('d-M-Y') }}</td>
                            <td>
                                <a href="{{ route('parties.show', $sale->party) }}">{{ $sale->party->name }}</a>
                            </td>
                            <td>{{ $sale->payment_type ?? '-' }}</td>
                            <td class="text-right">{{ number_format($sale->sub_total, 2) }}</td>
                            <td class="text-right">{{ number_format($sale->discount_amount, 2) }}</td>
                            <td class="text-right"><strong style="color: var(--success-color);">{{ number_format($sale->total_amount, 2) }}</strong></td>
                            <td class="text-center">
                                <a href="{{ route('sales.show', $sale) }}" class="btn btn-outline" style="padding: 0.25rem 0.5rem;" title="View">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="{{ route('sales.print', $sale) }}" class="btn btn-outline" style="padding: 0.25rem 0.5rem;" title="Print" target="_blank">
                                    <i class="fas fa-print"></i>
                                </a>
                                <a href="{{ route('sales.edit', $sale) }}" class="btn btn-outline" style="padding: 0.25rem 0.5rem;" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form action="{{ route('sales.destroy', $sale) }}" method="POST" style="display: inline;">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-outline" style="padding: 0.25rem 0.5rem; color: var(--danger-color);" 
                                            onclick="return confirm('Delete this sale bill? This will reverse stock and ledger entries.')" title="Delete">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="text-center text-muted" style="padding: 3rem;">
                                <i class="fas fa-file-invoice" style="font-size: 3rem; display: block; margin-bottom: 1rem; opacity: 0.5;"></i>
                                <p style="margin: 0;">No sale bills found. <a href="{{ route('sales.create') }}">Create your first sale</a></p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        @if($sales->hasPages())
            <div style="margin-top: 1rem;">
                {{ $sales->links() }}
            </div>
        @endif

        <!-- Summary -->
        <div style="display: flex; justify-content: flex-end; margin-top: 1rem; padding-top: 1rem; border-top: 1px solid var(--border-color);">
            <table style="width: 350px; border: 1px solid var(--border-color); border-radius: var(--border-radius);">
                <tr>
                    <td style="padding: 0.5rem 1rem; border-bottom: 1px solid var(--border-color);">Total Bills:</td>
                    <td style="padding: 0.5rem 1rem; border-bottom: 1px solid var(--border-color); text-align: right;"><strong>{{ $totals['count'] }}</strong></td>
                </tr>
                <tr>
                    <td style="padding: 0.5rem 1rem; border-bottom: 1px solid var(--border-color);">Gross Amount:</td>
                    <td style="padding: 0.5rem 1rem; border-bottom: 1px solid var(--border-color); text-align: right;">Rs. {{ number_format($totals['gross'], 2) }}</td>
                </tr>
                <tr>
                    <td style="padding: 0.5rem 1rem; border-bottom: 1px solid var(--border-color);">Total Discount:</td>
                    <td style="padding: 0.5rem 1rem; border-bottom: 1px solid var(--border-color); text-align: right; color: var(--danger-color);">- Rs. {{ number_format($totals['discount'], 2) }}</td>
                </tr>
                <tr style="background: var(--light-bg);">
                    <td style="padding: 0.75rem 1rem;"><strong>Net Amount:</strong></td>
                    <td style="padding: 0.75rem 1rem; text-align: right;"><strong class="text-success" style="font-size: 1.1rem;">Rs. {{ number_format($totals['net'], 2) }}</strong></td>
                </tr>
            </table>
        </div>
    </div>
</div>
@endsection
