@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-boxes"></i> Stock Report</h3>
        <button class="btn btn-outline" onclick="window.print()">
            <i class="fas fa-print"></i> Print
        </button>
    </div>
    <div class="card-body">
        <!-- Filters -->
        <form method="GET" action="{{ route('reports.stock') }}" class="mb-4">
            <div class="form-row">
                <div class="form-group" style="flex: 0 0 200px;">
                    <label class="form-label">Item Type</label>
                    <select name="type" class="form-control">
                        <option value="">All Types</option>
                        <option value="RAW" {{ $type == 'RAW' ? 'selected' : '' }}>RAW Material</option>
                        <option value="FINISH" {{ $type == 'FINISH' ? 'selected' : '' }}>FINISH Product</option>
                    </select>
                </div>
                <div class="form-group" style="flex: 0 0 auto; display: flex; align-items: flex-end;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-search"></i> View Stock
                    </button>
                </div>
            </div>
        </form>

        <!-- Stock Summary -->
        <div class="form-row mb-4">
            <div class="form-group" style="flex: 1;">
                <div class="card" style="background: var(--success-color); color: #fff; padding: 1rem; text-align: center;">
                    <div style="font-size: 0.875rem;">Total Items</div>
                    <div style="font-size: 1.5rem; font-weight: 700;">{{ $items->count() }}</div>
                </div>
            </div>
            <div class="form-group" style="flex: 1;">
                <div class="card" style="background: var(--primary-color); color: #fff; padding: 1rem; text-align: center;">
                    <div style="font-size: 0.875rem;">Total Stock Qty</div>
                    <div style="font-size: 1.5rem; font-weight: 700;">{{ number_format($totalStock, 2) }}</div>
                </div>
            </div>
            <div class="form-group" style="flex: 1;">
                <div class="card" style="background: var(--warning-color); color: #000; padding: 1rem; text-align: center;">
                    <div style="font-size: 0.875rem;">Total Value</div>
                    <div style="font-size: 1.5rem; font-weight: 700;">Rs. {{ number_format($totalValue, 2) }}</div>
                </div>
            </div>
        </div>

        <!-- Stock Table -->
        <table>
            <thead>
                <tr>
                    <th style="width: 80px;">Code</th>
                    <th>Item Name</th>
                    <th style="width: 80px;">Type</th>
                    <th style="width: 80px;">Unit</th>
                    <th class="text-right" style="width: 100px;">Stock Qty</th>
                    <th class="text-right" style="width: 120px;">Rate</th>
                    <th class="text-right" style="width: 130px;">Value</th>
                </tr>
            </thead>
            <tbody>
                @forelse($items as $item)
                <tr>
                    <td>{{ $item->code }}</td>
                    <td>
                        <a href="{{ route('items.show', $item) }}">{{ $item->name }}</a>
                    </td>
                    <td>
                        <span class="badge {{ $item->type == 'RAW' ? 'badge-info' : 'badge-success' }}">
                            {{ $item->type }}
                        </span>
                    </td>
                    <td>{{ $item->unit }}</td>
                    <td class="text-right {{ $item->stock_qty <= 0 ? 'text-danger' : '' }}">
                        {{ number_format($item->stock_qty, 2) }}
                    </td>
                    <td class="text-right">{{ number_format($item->purchase_price, 2) }}</td>
                    <td class="text-right">{{ number_format($item->stock_qty * $item->purchase_price, 2) }}</td>
                </tr>
                @empty
                <tr>
                    <td colspan="7" class="text-center">No items found</td>
                </tr>
                @endforelse
            </tbody>
            <tfoot>
                <tr style="background: var(--light-bg); font-weight: 700;">
                    <td colspan="4" class="text-right">Total:</td>
                    <td class="text-right">{{ number_format($totalStock, 2) }}</td>
                    <td class="text-right">-</td>
                    <td class="text-right">Rs. {{ number_format($totalValue, 2) }}</td>
                </tr>
            </tfoot>
        </table>
    </div>
</div>
@endsection
