@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-file-alt"></i> Account Ledger</h3>
        <div style="display: flex; gap: 0.5rem;">
            @if($selectedAccount)
            <button class="btn btn-outline" onclick="window.print()">
                <i class="fas fa-print"></i> Print
            </button>
            @endif
        </div>
    </div>
    <div class="card-body">
        <!-- Filters -->
        <form method="GET" action="{{ route('reports.ledger') }}" class="mb-4">
            <div class="form-row">
                <div class="form-group" style="flex: 1;">
                    <label class="form-label">Select Account <span class="text-danger">*</span></label>
                    <select name="account_id" class="form-control" required>
                        <option value="">-- Select Account --</option>
                        @foreach($accounts->groupBy('type') as $type => $typeAccounts)
                        <optgroup label="{{ $type }}">
                            @foreach($typeAccounts as $acc)
                            <option value="{{ $acc->id }}" {{ $selectedAccount == $acc->id ? 'selected' : '' }}>
                                {{ $acc->code }} - {{ $acc->name }}
                            </option>
                            @endforeach
                        </optgroup>
                        @endforeach
                    </select>
                </div>
                <div class="form-group" style="flex: 0 0 150px;">
                    <label class="form-label">From Date</label>
                    <input type="date" name="from_date" class="form-control" value="{{ $fromDate }}">
                </div>
                <div class="form-group" style="flex: 0 0 150px;">
                    <label class="form-label">To Date</label>
                    <input type="date" name="to_date" class="form-control" value="{{ $toDate }}">
                </div>
                <div class="form-group" style="flex: 0 0 auto; display: flex; align-items: flex-end;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-search"></i> View Ledger
                    </button>
                </div>
            </div>
        </form>

        @if($account)
        <!-- Account Info -->
        <div class="alert alert-info">
            <strong>{{ $account->code }} - {{ $account->name }}</strong> | 
            Type: {{ $account->type }} | Sub-Type: {{ $account->sub_type }}
        </div>

        <!-- Ledger Table -->
        <table>
            <thead>
                <tr>
                    <th style="width: 100px;">Date</th>
                    <th>Particulars</th>
                    <th class="text-right" style="width: 120px;">Debit</th>
                    <th class="text-right" style="width: 120px;">Credit</th>
                    <th class="text-right" style="width: 130px;">Balance</th>
                </tr>
            </thead>
            <tbody>
                <tr style="background: var(--light-bg); font-weight: 600;">
                    <td>{{ \Carbon\Carbon::parse($fromDate)->format('d-M-Y') }}</td>
                    <td>Opening Balance</td>
                    <td class="text-right">-</td>
                    <td class="text-right">-</td>
                    <td class="text-right">
                        @if($openingBalance >= 0)
                            <span class="text-success">{{ number_format($openingBalance, 2) }} Dr</span>
                        @else
                            <span class="text-danger">{{ number_format(abs($openingBalance), 2) }} Cr</span>
                        @endif
                    </td>
                </tr>

                @php $runningBalance = $openingBalance; @endphp
                @forelse($entries as $entry)
                @php $runningBalance += $entry->debit - $entry->credit; @endphp
                <tr>
                    <td>{{ $entry->date->format('d-M-Y') }}</td>
                    <td>
                        @if($entry->transactionable)
                            @php $ref = $entry->transactionable; @endphp
                            @if($ref instanceof \App\Models\Purchase)
                                Purchase: {{ $ref->bill_no }}
                            @elseif($ref instanceof \App\Models\Sale)
                                Sale: {{ $ref->bill_no }}
                            @elseif($ref instanceof \App\Models\Voucher)
                                {{ $ref->type }}: {{ $ref->voucher_no }}
                            @else
                                {{ class_basename($ref) }}
                            @endif
                        @else
                            {{ $entry->description ?? 'Transaction' }}
                        @endif
                    </td>
                    <td class="text-right">{{ $entry->debit > 0 ? number_format($entry->debit, 2) : '-' }}</td>
                    <td class="text-right">{{ $entry->credit > 0 ? number_format($entry->credit, 2) : '-' }}</td>
                    <td class="text-right">
                        @if($runningBalance >= 0)
                            <span class="text-success">{{ number_format($runningBalance, 2) }} Dr</span>
                        @else
                            <span class="text-danger">{{ number_format(abs($runningBalance), 2) }} Cr</span>
                        @endif
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="5" class="text-center">No transactions found</td>
                </tr>
                @endforelse
            </tbody>
            <tfoot>
                <tr style="background: var(--light-bg); font-weight: 700;">
                    <td colspan="2" class="text-right">Period Total:</td>
                    <td class="text-right">{{ number_format($entries->sum('debit'), 2) }}</td>
                    <td class="text-right">{{ number_format($entries->sum('credit'), 2) }}</td>
                    <td class="text-right">
                        @if($runningBalance >= 0)
                            <span class="text-success">{{ number_format($runningBalance, 2) }} Dr</span>
                        @else
                            <span class="text-danger">{{ number_format(abs($runningBalance), 2) }} Cr</span>
                        @endif
                    </td>
                </tr>
            </tfoot>
        </table>
        @else
        <div class="alert alert-warning">
            <i class="fas fa-info-circle"></i> Please select an account to view its ledger.
        </div>
        @endif
    </div>
</div>
@endsection
