@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-file-alt"></i> Ledger Code Range Report</h3>
        <button class="btn btn-outline" onclick="window.print()">
            <i class="fas fa-print"></i> Print
        </button>
    </div>
    <div class="card-body">
        <!-- Filter -->
        <form method="GET" action="{{ route('reports.ledger-code-range') }}" class="mb-4">
            <div class="form-row">
                <div class="form-group" style="flex: 0 0 150px;">
                    <label class="form-label">From Code</label>
                    <input type="text" name="from_code" class="form-control" value="{{ $fromCode }}" placeholder="e.g., 1000">
                </div>
                <div class="form-group" style="flex: 0 0 150px;">
                    <label class="form-label">To Code</label>
                    <input type="text" name="to_code" class="form-control" value="{{ $toCode }}" placeholder="e.g., 9999">
                </div>
                <div class="form-group" style="flex: 0 0 150px;">
                    <label class="form-label">From Date</label>
                    <input type="date" name="from_date" class="form-control" value="{{ $fromDate }}">
                </div>
                <div class="form-group" style="flex: 0 0 150px;">
                    <label class="form-label">To Date</label>
                    <input type="date" name="to_date" class="form-control" value="{{ $toDate }}">
                </div>
                <div class="form-group" style="flex: 0 0 auto; display: flex; align-items: flex-end;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-search"></i> View
                    </button>
                </div>
            </div>
        </form>

        @if($fromCode && $toCode)
        <div class="alert alert-info">
            <strong>Code Range:</strong> {{ $fromCode }} to {{ $toCode }} |
            <strong>Accounts:</strong> {{ $accounts->count() }}
        </div>

        <table>
            <thead>
                <tr>
                    <th style="width: 80px;">Code</th>
                    <th>Account Name</th>
                    <th class="text-right" style="width: 120px;">Opening</th>
                    <th class="text-right" style="width: 120px;">Debit</th>
                    <th class="text-right" style="width: 120px;">Credit</th>
                    <th class="text-right" style="width: 130px;">Closing</th>
                </tr>
            </thead>
            <tbody>
                @forelse($accounts as $account)
                <tr>
                    <td>{{ $account->code }}</td>
                    <td>
                        <a href="{{ route('reports.ledger', ['account_id' => $account->id]) }}">
                            {{ $account->name }}
                        </a>
                    </td>
                    <td class="text-right">
                        @if($account->opening >= 0)
                            {{ number_format($account->opening, 2) }} Dr
                        @else
                            {{ number_format(abs($account->opening), 2) }} Cr
                        @endif
                    </td>
                    <td class="text-right">{{ number_format($account->period_debit, 2) }}</td>
                    <td class="text-right">{{ number_format($account->period_credit, 2) }}</td>
                    <td class="text-right">
                        @if($account->closing >= 0)
                            <span class="text-success">{{ number_format($account->closing, 2) }} Dr</span>
                        @else
                            <span class="text-danger">{{ number_format(abs($account->closing), 2) }} Cr</span>
                        @endif
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="6" class="text-center">No accounts found in the specified code range</td>
                </tr>
                @endforelse
            </tbody>
            <tfoot>
                <tr style="background: var(--light-bg); font-weight: 700;">
                    <td colspan="2" class="text-right">Total:</td>
                    <td class="text-right">{{ number_format($accounts->sum('opening'), 2) }}</td>
                    <td class="text-right">{{ number_format($accounts->sum('period_debit'), 2) }}</td>
                    <td class="text-right">{{ number_format($accounts->sum('period_credit'), 2) }}</td>
                    <td class="text-right">{{ number_format($accounts->sum('closing'), 2) }}</td>
                </tr>
            </tfoot>
        </table>
        @else
        <div class="alert alert-warning">
            <i class="fas fa-info-circle"></i> Please enter a code range to view accounts.
        </div>
        @endif
    </div>
</div>
@endsection
