@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-book"></i> General Ledger</h3>
        <button class="btn btn-outline" onclick="window.print()">
            <i class="fas fa-print"></i> Print
        </button>
    </div>
    <div class="card-body">
        <!-- Filter -->
        <form method="GET" action="{{ route('reports.general-ledger') }}" class="mb-4">
            <div class="form-row">
                <div class="form-group" style="flex: 0 0 150px;">
                    <label class="form-label">From Date</label>
                    <input type="date" name="from_date" class="form-control" value="{{ $fromDate }}">
                </div>
                <div class="form-group" style="flex: 0 0 150px;">
                    <label class="form-label">To Date</label>
                    <input type="date" name="to_date" class="form-control" value="{{ $toDate }}">
                </div>
                <div class="form-group" style="flex: 0 0 auto; display: flex; align-items: flex-end;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-search"></i> Generate
                    </button>
                </div>
            </div>
        </form>

        <div class="alert alert-info">
            <strong>Period:</strong> {{ \Carbon\Carbon::parse($fromDate)->format('d M Y') }} to {{ \Carbon\Carbon::parse($toDate)->format('d M Y') }} |
            <strong>Accounts with Activity:</strong> {{ $accounts->count() }}
        </div>

        @forelse($accounts as $account)
        <div class="card mb-4" style="border: 1px solid var(--border-color);">
            <div class="card-header" style="background: var(--primary-color); color: #fff; padding: 0.75rem;">
                <div style="display: flex; justify-content: space-between; align-items: center;">
                    <div>
                        <strong>{{ $account->code }} - {{ $account->name }}</strong>
                        <small class="badge" style="background: rgba(255,255,255,0.2); margin-left: 0.5rem;">{{ $account->type }}</small>
                    </div>
                    <div>
                        Opening: 
                        @if($account->opening >= 0)
                            {{ number_format($account->opening, 2) }} Dr
                        @else
                            {{ number_format(abs($account->opening), 2) }} Cr
                        @endif
                    </div>
                </div>
            </div>
            <div class="card-body" style="padding: 0;">
                <table style="margin: 0;">
                    <thead>
                        <tr>
                            <th style="width: 100px;">Date</th>
                            <th>Particulars</th>
                            <th class="text-right" style="width: 120px;">Debit</th>
                            <th class="text-right" style="width: 120px;">Credit</th>
                            <th class="text-right" style="width: 130px;">Balance</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php $balance = $account->opening; @endphp
                        @foreach($account->transactions as $txn)
                        @php $balance += $txn->debit - $txn->credit; @endphp
                        <tr>
                            <td>{{ $txn->date->format('d-M-Y') }}</td>
                            <td>
                                @if($txn->transactionable)
                                    @php $ref = $txn->transactionable; @endphp
                                    @if($ref instanceof \App\Models\Purchase)
                                        Purchase: {{ $ref->bill_no }}
                                    @elseif($ref instanceof \App\Models\Sale)
                                        Sale: {{ $ref->bill_no }}
                                    @elseif($ref instanceof \App\Models\Voucher)
                                        {{ $ref->type }}: {{ $ref->voucher_no }}
                                    @else
                                        {{ class_basename($ref) }}
                                    @endif
                                @else
                                    Transaction
                                @endif
                            </td>
                            <td class="text-right">{{ $txn->debit > 0 ? number_format($txn->debit, 2) : '-' }}</td>
                            <td class="text-right">{{ $txn->credit > 0 ? number_format($txn->credit, 2) : '-' }}</td>
                            <td class="text-right">
                                @if($balance >= 0)
                                    <span class="text-success">{{ number_format($balance, 2) }} Dr</span>
                                @else
                                    <span class="text-danger">{{ number_format(abs($balance), 2) }} Cr</span>
                                @endif
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr style="background: var(--light-bg); font-weight: 700;">
                            <td colspan="2" class="text-right">Closing Balance:</td>
                            <td class="text-right">{{ number_format($account->transactions->sum('debit'), 2) }}</td>
                            <td class="text-right">{{ number_format($account->transactions->sum('credit'), 2) }}</td>
                            <td class="text-right">
                                @if($account->closing >= 0)
                                    <span class="text-success">{{ number_format($account->closing, 2) }} Dr</span>
                                @else
                                    <span class="text-danger">{{ number_format(abs($account->closing), 2) }} Cr</span>
                                @endif
                            </td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
        @empty
        <div class="alert alert-warning">
            <i class="fas fa-info-circle"></i> No accounts with transactions found for the selected period.
        </div>
        @endforelse
    </div>
</div>
@endsection
