@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-calendar-day"></i> Daily Book</h3>
        <button class="btn btn-outline" onclick="window.print()">
            <i class="fas fa-print"></i> Print
        </button>
    </div>
    <div class="card-body">
        <!-- Date Filter -->
        <form method="GET" action="{{ route('reports.daily-book') }}" class="mb-4">
            <div class="form-row">
                <div class="form-group" style="flex: 0 0 180px;">
                    <label class="form-label">Select Date</label>
                    <input type="date" name="date" class="form-control" value="{{ $date }}">
                </div>
                <div class="form-group" style="flex: 0 0 auto; display: flex; align-items: flex-end;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-search"></i> View
                    </button>
                </div>
            </div>
        </form>

        <div class="alert alert-info">
            <strong>Date:</strong> {{ \Carbon\Carbon::parse($date)->format('l, d F Y') }} |
            <strong>Total Transactions:</strong> {{ $transactions->count() }}
        </div>

        <!-- Summary -->
        <div class="form-row mb-4">
            <div class="form-group" style="flex: 1;">
                <div class="card" style="background: var(--success-color); color: #fff; padding: 1rem; text-align: center;">
                    <div style="font-size: 0.875rem;">Total Debit</div>
                    <div style="font-size: 1.5rem; font-weight: 700;">Rs. {{ number_format($summary['total_debit'], 2) }}</div>
                </div>
            </div>
            <div class="form-group" style="flex: 1;">
                <div class="card" style="background: var(--danger-color); color: #fff; padding: 1rem; text-align: center;">
                    <div style="font-size: 0.875rem;">Total Credit</div>
                    <div style="font-size: 1.5rem; font-weight: 700;">Rs. {{ number_format($summary['total_credit'], 2) }}</div>
                </div>
            </div>
        </div>

        <!-- Transactions Table -->
        <table>
            <thead>
                <tr>
                    <th style="width: 60px;">#</th>
                    <th style="width: 80px;">Time</th>
                    <th>Account</th>
                    <th>Reference</th>
                    <th class="text-right" style="width: 120px;">Debit</th>
                    <th class="text-right" style="width: 120px;">Credit</th>
                </tr>
            </thead>
            <tbody>
                @forelse($transactions as $index => $txn)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $txn->created_at->format('H:i') }}</td>
                    <td>
                        <a href="{{ route('accounts.show', $txn->account) }}">
                            {{ $txn->account->code }} - {{ $txn->account->name }}
                        </a>
                    </td>
                    <td>
                        @if($txn->transactionable)
                            @php $ref = $txn->transactionable; @endphp
                            @if($ref instanceof \App\Models\Purchase)
                                <span class="badge badge-info">Purchase</span> {{ $ref->bill_no }}
                            @elseif($ref instanceof \App\Models\Sale)
                                <span class="badge badge-success">Sale</span> {{ $ref->bill_no }}
                            @elseif($ref instanceof \App\Models\Voucher)
                                <span class="badge badge-primary">{{ $ref->type }}</span> {{ $ref->voucher_no }}
                            @else
                                {{ class_basename($ref) }}
                            @endif
                        @else
                            -
                        @endif
                    </td>
                    <td class="text-right">
                        @if($txn->debit > 0)
                            <span class="text-success">{{ number_format($txn->debit, 2) }}</span>
                        @else
                            -
                        @endif
                    </td>
                    <td class="text-right">
                        @if($txn->credit > 0)
                            <span class="text-danger">{{ number_format($txn->credit, 2) }}</span>
                        @else
                            -
                        @endif
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="6" class="text-center">No transactions found for this date</td>
                </tr>
                @endforelse
            </tbody>
            <tfoot>
                <tr style="background: var(--light-bg); font-weight: 700;">
                    <td colspan="4" class="text-right">Total:</td>
                    <td class="text-right text-success">{{ number_format($summary['total_debit'], 2) }}</td>
                    <td class="text-right text-danger">{{ number_format($summary['total_credit'], 2) }}</td>
                </tr>
            </tfoot>
        </table>
    </div>
</div>
@endsection
