@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-sitemap"></i> Chart of Accounts</h3>
        <button class="btn btn-outline" onclick="window.print()">
            <i class="fas fa-print"></i> Print
        </button>
    </div>
    <div class="card-body">
        @forelse($accounts as $type => $typeAccounts)
        <div class="card mb-4" style="border: 1px solid var(--border-color);">
            <div class="card-header" style="background: var(--primary-color); color: #fff; padding: 0.75rem;">
                <h4 style="margin: 0; font-size: 1rem;">
                    <i class="fas fa-folder"></i> {{ $type }}
                    <span class="badge" style="background: rgba(255,255,255,0.2); margin-left: 0.5rem;">
                        {{ $typeAccounts->count() }} accounts
                    </span>
                </h4>
            </div>
            <div class="card-body" style="padding: 0;">
                <table style="margin: 0;">
                    <thead>
                        <tr>
                            <th style="width: 100px;">Code</th>
                            <th>Account Name</th>
                            <th style="width: 200px;">Sub Type</th>
                            <th style="width: 100px;">Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($typeAccounts as $account)
                        <tr>
                            <td><strong>{{ $account->code }}</strong></td>
                            <td>
                                <a href="{{ route('accounts.show', $account) }}">{{ $account->name }}</a>
                            </td>
                            <td>{{ $account->sub_type }}</td>
                            <td>
                                @if($account->is_active)
                                    <span class="badge badge-success">Active</span>
                                @else
                                    <span class="badge badge-danger">Inactive</span>
                                @endif
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        @empty
        <div class="alert alert-warning">
            <i class="fas fa-info-circle"></i> No accounts found.
        </div>
        @endforelse
    </div>
</div>
@endsection
