@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-balance-scale-right"></i> Balance Sheet</h3>
        <button class="btn btn-outline" onclick="window.print()">
            <i class="fas fa-print"></i> Print
        </button>
    </div>
    <div class="card-body">
        <!-- Filter -->
        <form method="GET" action="{{ route('reports.balance-sheet') }}" class="mb-4">
            <div class="form-row">
                <div class="form-group" style="flex: 0 0 180px;">
                    <label class="form-label">As On Date</label>
                    <input type="date" name="as_on_date" class="form-control" value="{{ $asOnDate }}">
                </div>
                <div class="form-group" style="flex: 0 0 auto; display: flex; align-items: flex-end;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-search"></i> Generate
                    </button>
                </div>
            </div>
        </form>

        <div class="alert alert-info">
            <strong>Balance Sheet as on:</strong> {{ \Carbon\Carbon::parse($asOnDate)->format('d F Y') }}
        </div>

        <div style="display: flex; gap: 2rem;">
            <!-- Assets Section -->
            <div style="flex: 1;">
                <h4 style="background: var(--primary-color); color: #fff; padding: 0.75rem; margin: 0;">
                    <i class="fas fa-coins"></i> Assets
                </h4>
                <table style="border: 1px solid var(--border-color);">
                    <tbody>
                        @forelse($assets as $account)
                        <tr>
                            <td>
                                <a href="{{ route('reports.ledger', ['account_id' => $account->id]) }}">
                                    {{ $account->name }}
                                </a>
                            </td>
                            <td class="text-right" style="width: 130px;">{{ number_format($account->balance, 2) }}</td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="2" class="text-center">No assets</td>
                        </tr>
                        @endforelse
                    </tbody>
                    <tfoot>
                        <tr style="background: var(--light-bg); font-weight: 700;">
                            <td>Total Assets</td>
                            <td class="text-right">Rs. {{ number_format($totalAssets, 2) }}</td>
                        </tr>
                    </tfoot>
                </table>
            </div>

            <!-- Liabilities & Equity Section -->
            <div style="flex: 1;">
                <h4 style="background: var(--warning-color); color: #000; padding: 0.75rem; margin: 0;">
                    <i class="fas fa-hand-holding-usd"></i> Liabilities
                </h4>
                <table style="border: 1px solid var(--border-color);">
                    <tbody>
                        @forelse($liabilities as $account)
                        <tr>
                            <td>
                                <a href="{{ route('reports.ledger', ['account_id' => $account->id]) }}">
                                    {{ $account->name }}
                                </a>
                            </td>
                            <td class="text-right" style="width: 130px;">{{ number_format($account->balance, 2) }}</td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="2" class="text-center">No liabilities</td>
                        </tr>
                        @endforelse
                    </tbody>
                    <tfoot>
                        <tr style="background: var(--light-bg); font-weight: 700;">
                            <td>Total Liabilities</td>
                            <td class="text-right">Rs. {{ number_format($totalLiabilities, 2) }}</td>
                        </tr>
                    </tfoot>
                </table>

                <h4 style="background: var(--success-color); color: #fff; padding: 0.75rem; margin: 1rem 0 0 0;">
                    <i class="fas fa-user-tie"></i> Equity
                </h4>
                <table style="border: 1px solid var(--border-color);">
                    <tbody>
                        @forelse($equity as $account)
                        <tr>
                            <td>
                                <a href="{{ route('reports.ledger', ['account_id' => $account->id]) }}">
                                    {{ $account->name }}
                                </a>
                            </td>
                            <td class="text-right" style="width: 130px;">{{ number_format($account->balance, 2) }}</td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="2" class="text-center">No equity accounts</td>
                        </tr>
                        @endforelse
                    </tbody>
                    <tfoot>
                        <tr style="background: var(--light-bg); font-weight: 700;">
                            <td>Total Equity</td>
                            <td class="text-right">Rs. {{ number_format($totalEquity, 2) }}</td>
                        </tr>
                        <tr style="background: var(--primary-color); color: #fff; font-weight: 700;">
                            <td>Liabilities + Equity</td>
                            <td class="text-right">Rs. {{ number_format($totalLiabilities + $totalEquity, 2) }}</td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>

        <!-- Balance Check -->
        @php $difference = $totalAssets - ($totalLiabilities + $totalEquity); @endphp
        <div class="card mt-4" style="background: {{ abs($difference) < 0.01 ? 'var(--success-color)' : 'var(--danger-color)' }}; color: #fff; padding: 1rem; text-align: center;">
            @if(abs($difference) < 0.01)
                <i class="fas fa-check-circle"></i> <strong>Balanced</strong> - Assets = Liabilities + Equity
            @else
                <i class="fas fa-exclamation-triangle"></i> <strong>Not Balanced</strong> - Difference: Rs. {{ number_format(abs($difference), 2) }}
            @endif
        </div>
    </div>
</div>
@endsection
