@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-clock"></i> Aging Report</h3>
        <button class="btn btn-outline" onclick="window.print()">
            <i class="fas fa-print"></i> Print
        </button>
    </div>
    <div class="card-body">
        <!-- Filter -->
        <form method="GET" action="{{ route('reports.aging') }}" class="mb-4">
            <div class="form-row">
                <div class="form-group" style="flex: 0 0 200px;">
                    <label class="form-label">Report Type</label>
                    <select name="type" class="form-control">
                        <option value="receivable" {{ $type == 'receivable' ? 'selected' : '' }}>Receivables (Sales)</option>
                        <option value="payable" {{ $type == 'payable' ? 'selected' : '' }}>Payables (Purchases)</option>
                    </select>
                </div>
                <div class="form-group" style="flex: 0 0 180px;">
                    <label class="form-label">As On Date</label>
                    <input type="date" name="as_on_date" class="form-control" value="{{ $asOnDate }}">
                </div>
                <div class="form-group" style="flex: 0 0 auto; display: flex; align-items: flex-end;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-search"></i> Generate
                    </button>
                </div>
            </div>
        </form>

        <div class="alert alert-info">
            <strong>{{ $type == 'receivable' ? 'Outstanding Receivables' : 'Outstanding Payables' }}</strong> as on {{ \Carbon\Carbon::parse($asOnDate)->format('d F Y') }}
        </div>

        <!-- Aging Summary -->
        @php
            $bucket0_30 = $entries->where('aging_bucket', '0-30 Days');
            $bucket31_60 = $entries->where('aging_bucket', '31-60 Days');
            $bucket61_90 = $entries->where('aging_bucket', '61-90 Days');
            $bucket90plus = $entries->where('aging_bucket', '90+ Days');
        @endphp
        <div class="form-row mb-4">
            <div class="form-group" style="flex: 1;">
                <div class="card" style="background: var(--success-color); color: #fff; padding: 1rem; text-align: center;">
                    <div style="font-size: 0.75rem;">0-30 Days</div>
                    <div style="font-size: 1.25rem; font-weight: 700;">Rs. {{ number_format($bucket0_30->sum('due_amount'), 2) }}</div>
                    <div style="font-size: 0.75rem;">{{ $bucket0_30->count() }} items</div>
                </div>
            </div>
            <div class="form-group" style="flex: 1;">
                <div class="card" style="background: var(--warning-color); color: #000; padding: 1rem; text-align: center;">
                    <div style="font-size: 0.75rem;">31-60 Days</div>
                    <div style="font-size: 1.25rem; font-weight: 700;">Rs. {{ number_format($bucket31_60->sum('due_amount'), 2) }}</div>
                    <div style="font-size: 0.75rem;">{{ $bucket31_60->count() }} items</div>
                </div>
            </div>
            <div class="form-group" style="flex: 1;">
                <div class="card" style="background: #fd7e14; color: #fff; padding: 1rem; text-align: center;">
                    <div style="font-size: 0.75rem;">61-90 Days</div>
                    <div style="font-size: 1.25rem; font-weight: 700;">Rs. {{ number_format($bucket61_90->sum('due_amount'), 2) }}</div>
                    <div style="font-size: 0.75rem;">{{ $bucket61_90->count() }} items</div>
                </div>
            </div>
            <div class="form-group" style="flex: 1;">
                <div class="card" style="background: var(--danger-color); color: #fff; padding: 1rem; text-align: center;">
                    <div style="font-size: 0.75rem;">90+ Days</div>
                    <div style="font-size: 1.25rem; font-weight: 700;">Rs. {{ number_format($bucket90plus->sum('due_amount'), 2) }}</div>
                    <div style="font-size: 0.75rem;">{{ $bucket90plus->count() }} items</div>
                </div>
            </div>
        </div>

        <!-- Details Table -->
        <table>
            <thead>
                <tr>
                    <th style="width: 100px;">Bill No</th>
                    <th style="width: 100px;">Date</th>
                    <th>Party</th>
                    <th class="text-right" style="width: 120px;">Amount</th>
                    <th class="text-right" style="width: 100px;">Due</th>
                    <th style="width: 80px;">Days</th>
                    <th style="width: 100px;">Bucket</th>
                </tr>
            </thead>
            <tbody>
                @forelse($entries as $entry)
                <tr>
                    <td>
                        @if($type == 'receivable')
                            <a href="{{ route('sales.show', $entry) }}">{{ $entry->bill_no }}</a>
                        @else
                            <a href="{{ route('purchases.show', $entry) }}">{{ $entry->bill_no }}</a>
                        @endif
                    </td>
                    <td>{{ $entry->date->format('d-M-Y') }}</td>
                    <td>{{ $entry->party->name ?? 'N/A' }}</td>
                    <td class="text-right">{{ number_format($entry->total_amount, 2) }}</td>
                    <td class="text-right text-danger">{{ number_format($entry->due_amount, 2) }}</td>
                    <td class="text-center">{{ $entry->days_outstanding }}</td>
                    <td>
                        @if($entry->aging_bucket == '0-30 Days')
                            <span class="badge badge-success">{{ $entry->aging_bucket }}</span>
                        @elseif($entry->aging_bucket == '31-60 Days')
                            <span class="badge badge-warning">{{ $entry->aging_bucket }}</span>
                        @elseif($entry->aging_bucket == '61-90 Days')
                            <span class="badge" style="background: #fd7e14; color: #fff;">{{ $entry->aging_bucket }}</span>
                        @else
                            <span class="badge badge-danger">{{ $entry->aging_bucket }}</span>
                        @endif
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="7" class="text-center">No outstanding {{ $type == 'receivable' ? 'receivables' : 'payables' }} found</td>
                </tr>
                @endforelse
            </tbody>
            <tfoot>
                <tr style="background: var(--light-bg); font-weight: 700;">
                    <td colspan="3" class="text-right">Total Outstanding:</td>
                    <td class="text-right">{{ number_format($entries->sum('total_amount'), 2) }}</td>
                    <td class="text-right text-danger">{{ number_format($entries->sum('due_amount'), 2) }}</td>
                    <td colspan="2"></td>
                </tr>
            </tfoot>
        </table>
    </div>
</div>
@endsection
