@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-industry"></i> Production Batch: {{ $production->batch_no }}</h3>
        <div style="display: flex; gap: 0.5rem;">
            <a href="{{ route('production.print', $production) }}" class="btn btn-outline" target="_blank">
                <i class="fas fa-print"></i> Print
            </a>
            <a href="{{ route('production.edit', $production) }}" class="btn btn-outline">
                <i class="fas fa-edit"></i> Edit Costs
            </a>
            <a href="{{ route('production.index') }}" class="btn btn-outline">
                <i class="fas fa-arrow-left"></i> Back
            </a>
        </div>
    </div>
    <div class="card-body">
        @if(session('success'))
            <div style="background-color: #d4edda; border: 1px solid #c3e6cb; color: #155724; padding: 1rem; border-radius: 4px; margin-bottom: 1rem;">
                <i class="fas fa-check-circle"></i> {{ session('success') }}
            </div>
        @endif

        <!-- Production Header Info -->
        <div class="form-row mb-4">
            <div class="form-group" style="flex: 1;">
                <label class="form-label text-muted">Batch No</label>
                <div style="font-size: 1.25rem; font-weight: 700; color: var(--primary-color);">{{ $production->batch_no }}</div>
            </div>
            <div class="form-group" style="flex: 1;">
                <label class="form-label text-muted">Date</label>
                <div style="font-size: 1.1rem;">{{ $production->date->format('d-M-Y') }}</div>
            </div>
            <div class="form-group" style="flex: 1;">
                <label class="form-label text-muted">Machine / Process</label>
                <div style="font-size: 1.1rem;">{{ $production->machine ?? '-' }}</div>
            </div>
            <div class="form-group" style="flex: 1;">
                <label class="form-label text-muted">Status</label>
                <div>
                    <span style="background-color: #28a745; color: white; padding: 0.25rem 0.75rem; border-radius: 4px;">
                        {{ ucfirst($production->status) }}
                    </span>
                </div>
            </div>
        </div>

        @php
            $totalRawWeight = $production->inputItems->sum('quantity');
            $totalFinishWeight = $production->outputItems->sum('quantity');
            $totalWastageWeight = $production->wastageItems ? $production->wastageItems->sum('quantity') : 0;
            $totalFinishAmount = $production->outputItems->sum('amount');
            $wastagePercent = $totalRawWeight > 0 ? ($totalWastageWeight / $totalRawWeight) * 100 : 0;
            
            // Calculate wastage weight (input - output)
            $actualWastage = $totalRawWeight - $totalFinishWeight;
            
            // Calculate wastage cost (proportional cost of wasted material)
            $wastageCost = $totalRawWeight > 0 ? ($actualWastage / $totalRawWeight) * $production->raw_material_cost : 0;
            
            // Wastage cost per unit of output
            $wastePerUnit = $totalFinishWeight > 0 ? $wastageCost / $totalFinishWeight : 0;
            
            // Wastage percentage of output
            $wastageOutputPercent = $totalRawWeight > 0 ? (($totalRawWeight - $totalFinishWeight) / $totalRawWeight) * 100 : 0;
        @endphp

        <!-- Side by Side Tables like Excel -->
        <div class="production-tables" style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem; margin-bottom: 1.5rem;">
            
            <!-- RAW MATERIAL Section (Left) -->
            <div style="border: 2px solid #dc3545; border-radius: 8px; overflow: hidden;">
                <div style="background: #fff; padding: 0.75rem; text-align: center; border-bottom: 2px solid #dc3545;">
                    <h4 style="margin: 0; color: #dc3545; font-size: 1.25rem; font-weight: 700;">
                        <i class="fas fa-arrow-right"></i> RAW MATERIAL
                    </h4>
                </div>
                
                <table style="width: 100%; border-collapse: collapse;">
                    <thead>
                        <tr style="background: #f8f9fa;">
                            <th style="border: 1px solid #ddd; padding: 10px; text-align: left;">Description</th>
                            <th style="border: 1px solid #ddd; padding: 10px; text-align: right; width: 90px;">Total Weight</th>
                            <th style="border: 1px solid #ddd; padding: 10px; text-align: right; width: 60px;">%</th>
                            <th style="border: 1px solid #ddd; padding: 10px; text-align: right; width: 80px;">Rate</th>
                            <th style="border: 1px solid #ddd; padding: 10px; text-align: right; width: 110px;">Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($production->inputItems as $item)
                            @php
                                $percentage = $totalRawWeight > 0 ? ($item->quantity / $totalRawWeight) * 100 : 0;
                            @endphp
                            <tr>
                                <td style="border: 1px solid #ddd; padding: 10px;">{{ $item->item->name ?? '-' }}</td>
                                <td style="border: 1px solid #ddd; padding: 10px; text-align: right;">{{ number_format($item->quantity, 0) }}</td>
                                <td style="border: 1px solid #ddd; padding: 10px; text-align: right;">{{ number_format($percentage, 2) }}</td>
                                <td style="border: 1px solid #ddd; padding: 10px; text-align: right;">{{ number_format($item->rate, 2) }}</td>
                                <td style="border: 1px solid #ddd; padding: 10px; text-align: right; font-weight: 600;">{{ number_format($item->amount, 0) }}</td>
                            </tr>
                        @endforeach
                        
                        {{-- Empty rows to match Excel style --}}
                        @for($i = $production->inputItems->count(); $i < 8; $i++)
                            <tr>
                                <td style="border: 1px solid #ddd; padding: 10px;">&nbsp;</td>
                                <td style="border: 1px solid #ddd; padding: 10px;"></td>
                                <td style="border: 1px solid #ddd; padding: 10px;"></td>
                                <td style="border: 1px solid #ddd; padding: 10px;"></td>
                                <td style="border: 1px solid #ddd; padding: 10px; text-align: right;">0</td>
                            </tr>
                        @endfor
                    </tbody>
                    <tfoot>
                        <!-- Wastage Row -->
                        @if($totalWastageWeight > 0)
                        <tr style="background: #fff3cd;">
                            <td style="border: 1px solid #ddd; padding: 10px; font-weight: 600;">Panjee (Wastage)</td>
                            <td style="border: 1px solid #ddd; padding: 10px; text-align: right; font-weight: 600;">{{ number_format($totalWastageWeight, 0) }}</td>
                            <td style="border: 1px solid #ddd; padding: 10px; text-align: right;">{{ number_format($wastagePercent, 2) }}</td>
                            <td style="border: 1px solid #ddd; padding: 10px;"></td>
                            <td style="border: 1px solid #ddd; padding: 10px;"></td>
                        </tr>
                        @endif
                        <!-- Total Row -->
                        <tr style="background: #f8d7da;">
                            <td style="border: 1px solid #ddd; padding: 10px; font-weight: 700;">TOTAL</td>
                            <td style="border: 1px solid #ddd; padding: 10px; text-align: right; font-weight: 700; font-size: 1.1rem;">{{ number_format($totalRawWeight, 0) }}</td>
                            <td style="border: 1px solid #ddd; padding: 10px; text-align: right; font-weight: 700;">100.00</td>
                            <td style="border: 1px solid #ddd; padding: 10px;"></td>
                            <td style="border: 1px solid #ddd; padding: 10px; text-align: right; font-weight: 700; font-size: 1.1rem;">{{ number_format($production->raw_material_cost, 0) }}</td>
                        </tr>
                    </tfoot>
                </table>
            </div>
            
            <!-- FINISH MATERIAL Section (Right) -->
            <div style="border: 2px solid #28a745; border-radius: 8px; overflow: hidden;">
                <div style="background: #ffff00; padding: 0.75rem; text-align: center; border-bottom: 2px solid #28a745;">
                    <h4 style="margin: 0; color: #000; font-size: 1.25rem; font-weight: 700;">
                        <i class="fas fa-arrow-left"></i> FINISH MATERIAL
                    </h4>
                </div>
                
                <table style="width: 100%; border-collapse: collapse;">
                    <thead>
                        <tr style="background: #f8f9fa;">
                            <th style="border: 1px solid #ddd; padding: 10px; text-align: left;">Description</th>
                            <th style="border: 1px solid #ddd; padding: 10px; text-align: right; width: 90px;">Total Weight</th>
                            <th style="border: 1px solid #ddd; padding: 10px; text-align: right; width: 80px;">Rate</th>
                            <th style="border: 1px solid #ddd; padding: 10px; text-align: right; width: 110px;">Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($production->outputItems as $item)
                            <tr>
                                <td style="border: 1px solid #ddd; padding: 10px;">{{ $item->item->name ?? '-' }}</td>
                                <td style="border: 1px solid #ddd; padding: 10px; text-align: right;">{{ number_format($item->quantity, 0) }}</td>
                                <td style="border: 1px solid #ddd; padding: 10px; text-align: right;">{{ number_format($item->rate, 2) }}</td>
                                <td style="border: 1px solid #ddd; padding: 10px; text-align: right; font-weight: 600;">{{ number_format($item->amount, 0) }}</td>
                            </tr>
                        @endforeach
                        
                        {{-- Empty rows to match Excel style --}}
                        @for($i = $production->outputItems->count(); $i < 8; $i++)
                            <tr>
                                <td style="border: 1px solid #ddd; padding: 10px;">&nbsp;</td>
                                <td style="border: 1px solid #ddd; padding: 10px;"></td>
                                <td style="border: 1px solid #ddd; padding: 10px;"></td>
                                <td style="border: 1px solid #ddd; padding: 10px; text-align: right;">0</td>
                            </tr>
                        @endfor
                    </tbody>
                    <tfoot>
                        <!-- Panjee Row (Reference from input) -->
                        <tr style="background: #fff3cd;">
                            <td style="border: 1px solid #ddd; padding: 10px; font-weight: 600;">Panjee</td>
                            <td style="border: 1px solid #ddd; padding: 10px; text-align: right; font-weight: 600;">{{ number_format($totalRawWeight, 0) }}</td>
                            <td style="border: 1px solid #ddd; padding: 10px;"></td>
                            <td style="border: 1px solid #ddd; padding: 10px;"></td>
                        </tr>
                        <!-- Total Row -->
                        <tr style="background: #d4edda;">
                            <td style="border: 1px solid #ddd; padding: 10px; font-weight: 700;">TOTAL</td>
                            <td style="border: 1px solid #ddd; padding: 10px; text-align: right; font-weight: 700; font-size: 1.1rem;">{{ number_format($totalFinishWeight, 0) }}</td>
                            <td style="border: 1px solid #ddd; padding: 10px;"></td>
                            <td style="border: 1px solid #ddd; padding: 10px; text-align: right; font-weight: 700; font-size: 1.1rem;">{{ number_format($totalFinishAmount, 0) }}</td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>

        <!-- Summary Cards -->
        <div class="summary-cards" style="display: grid; grid-template-columns: repeat(4, 1fr); gap: 1rem; margin-bottom: 1.5rem;">
            <div style="background: linear-gradient(135deg, #ff6b6b, #ee5a5a); color: white; padding: 1.25rem; border-radius: 8px; text-align: center;">
                <div style="font-size: 0.875rem; opacity: 0.9;"><i class="fas fa-cubes"></i> Raw Material Cost</div>
                <div style="font-size: 1.5rem; font-weight: 700;">Rs. {{ number_format($production->raw_material_cost, 0) }}</div>
            </div>
            <div style="background: linear-gradient(135deg, #4ecdc4, #44a08d); color: white; padding: 1.25rem; border-radius: 8px; text-align: center;">
                <div style="font-size: 0.875rem; opacity: 0.9;"><i class="fas fa-weight"></i> Total Output Weight</div>
                <div style="font-size: 1.5rem; font-weight: 700;">{{ number_format($totalFinishWeight, 0) }} KG</div>
            </div>
            <div style="background: linear-gradient(135deg, #a8e063, #56ab2f); color: white; padding: 1.25rem; border-radius: 8px; text-align: center;">
                <div style="font-size: 0.875rem; opacity: 0.9;"><i class="fas fa-money-bill-wave"></i> Finish Material Value</div>
                <div style="font-size: 1.5rem; font-weight: 700;">Rs. {{ number_format($totalFinishAmount, 0) }}</div>
            </div>
            <div style="background: linear-gradient(135deg, #667eea, #764ba2); color: white; padding: 1.25rem; border-radius: 8px; text-align: center;">
                <div style="font-size: 0.875rem; opacity: 0.9;"><i class="fas fa-calculator"></i> Avg Cost Per KG</div>
                <div style="font-size: 1.5rem; font-weight: 700;">Rs. {{ number_format($production->cost_per_unit, 2) }}</div>
            </div>
        </div>

        <!-- Wastage Calculation Row -->
        <div style="background: linear-gradient(135deg, #f39c12, #e67e22); color: white; padding: 1rem; border-radius: 8px; margin-bottom: 1.5rem;">
            <div style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 1rem;">
                <div style="text-align: center; flex: 1; min-width: 120px;">
                    <div style="font-size: 0.8rem; opacity: 0.9;"><i class="fas fa-arrow-right"></i> Input Weight</div>
                    <div style="font-size: 1.25rem; font-weight: 700;">{{ number_format($totalRawWeight, 0) }} KG</div>
                </div>
                <div style="font-size: 1.5rem; opacity: 0.7;">−</div>
                <div style="text-align: center; flex: 1; min-width: 120px;">
                    <div style="font-size: 0.8rem; opacity: 0.9;"><i class="fas fa-arrow-left"></i> Output Weight</div>
                    <div style="font-size: 1.25rem; font-weight: 700;">{{ number_format($totalFinishWeight, 0) }} KG</div>
                </div>
                <div style="font-size: 1.5rem; opacity: 0.7;">=</div>
                <div style="text-align: center; flex: 1; min-width: 120px;">
                    <div style="font-size: 0.8rem; opacity: 0.9;"><i class="fas fa-trash-alt"></i> Wastage Weight</div>
                    <div style="font-size: 1.25rem; font-weight: 700;">{{ number_format($actualWastage, 0) }} KG</div>
                </div>
                <div style="font-size: 1.5rem; opacity: 0.7;">|</div>
                <div style="text-align: center; flex: 1; min-width: 100px;">
                    <div style="font-size: 0.8rem; opacity: 0.9;"><i class="fas fa-percent"></i> Wastage %</div>
                    <div style="font-size: 1.25rem; font-weight: 700;">{{ number_format($wastageOutputPercent, 2) }}%</div>
                </div>
                <div style="font-size: 1.5rem; opacity: 0.7;">|</div>
                <div style="text-align: center; flex: 1; min-width: 130px;">
                    <div style="font-size: 0.8rem; opacity: 0.9;"><i class="fas fa-coins"></i> Wastage Cost</div>
                    <div style="font-size: 1.25rem; font-weight: 700;">Rs. {{ number_format($wastageCost, 0) }}</div>
                </div>
                <div style="font-size: 1.5rem; opacity: 0.7;">|</div>
                <div style="text-align: center; flex: 1; min-width: 130px; background: rgba(0,0,0,0.2); padding: 0.5rem; border-radius: 6px;">
                    <div style="font-size: 0.8rem; opacity: 0.9;"><i class="fas fa-recycle"></i> Waste Per Unit</div>
                    <div style="font-size: 1.25rem; font-weight: 700;">Rs. {{ number_format($wastePerUnit, 2) }}/KG</div>
                </div>
            </div>
        </div>

        <!-- Cost Breakdown -->
        <div class="form-row" style="gap: 1.5rem;">
            <!-- Additional Costs -->
            <div style="flex: 1; background: #fce4ec; padding: 1rem; border-radius: 8px; border: 1px solid #f8bbd9;">
                <h4 style="margin: 0 0 1rem 0; color: #c2185b;"><i class="fas fa-coins"></i> Production Costs Breakdown</h4>
                
                <table style="width: 100%; border: none;">
                    <tr>
                        <td style="padding: 0.5rem; border: none;">Raw Material Cost:</td>
                        <td style="padding: 0.5rem; border: none; text-align: right;">Rs. {{ number_format($production->raw_material_cost, 2) }}</td>
                    </tr>
                    <tr>
                        <td style="padding: 0.5rem; border: none;">Agent Commission:</td>
                        <td style="padding: 0.5rem; border: none; text-align: right;">Rs. {{ number_format($production->agent_commission, 2) }}</td>
                    </tr>
                    <tr>
                        <td style="padding: 0.5rem; border: none;">Transportation Cost:</td>
                        <td style="padding: 0.5rem; border: none; text-align: right;">Rs. {{ number_format($production->transportation_cost, 2) }}</td>
                    </tr>
                    <tr>
                        <td style="padding: 0.5rem; border: none;">Labor Cost:</td>
                        <td style="padding: 0.5rem; border: none; text-align: right;">Rs. {{ number_format($production->labor_cost, 2) }}</td>
                    </tr>
                    <tr>
                        <td style="padding: 0.5rem; border: none;">Electricity Cost:</td>
                        <td style="padding: 0.5rem; border: none; text-align: right;">Rs. {{ number_format($production->electricity_cost, 2) }}</td>
                    </tr>
                    <tr>
                        <td style="padding: 0.5rem; border: none;">Other Expenses:</td>
                        <td style="padding: 0.5rem; border: none; text-align: right;">Rs. {{ number_format($production->other_expenses, 2) }}</td>
                    </tr>
                    @if($production->other_expenses_description)
                    <tr>
                        <td colspan="2" style="padding: 0.5rem; border: none; font-size: 0.85rem; color: #666;">
                            <em>{{ $production->other_expenses_description }}</em>
                        </td>
                    </tr>
                    @endif
                    <tr style="background: #f8bbd9;">
                        <td style="padding: 0.75rem; border: none; font-weight: 700; font-size: 1.1rem;">TOTAL COST:</td>
                        <td style="padding: 0.75rem; border: none; text-align: right; font-weight: 700; font-size: 1.25rem;">Rs. {{ number_format($production->total_cost, 2) }}</td>
                    </tr>
                </table>
            </div>

            <!-- Cost Per Unit Summary -->
            <div style="flex: 0 0 350px;">
                <div style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 1.5rem; border-radius: 8px; color: white; text-align: center; height: 100%;">
                    <h4 style="margin: 0 0 1.5rem 0;"><i class="fas fa-calculator"></i> Cost Per Unit Calculation</h4>
                    
                    <div style="margin-bottom: 1rem;">
                        <div style="font-size: 0.875rem; opacity: 0.9;">Total Production Cost</div>
                        <div style="font-size: 1.5rem; font-weight: 700;">Rs. {{ number_format($production->total_cost, 2) }}</div>
                    </div>
                    
                    <div style="margin-bottom: 1rem;">
                        <div style="font-size: 0.875rem; opacity: 0.9;">÷ Output Quantity</div>
                        <div style="font-size: 1.5rem; font-weight: 700;">{{ number_format($production->output_quantity, 3) }} KG</div>
                    </div>
                    
                    <div style="border-top: 2px solid rgba(255,255,255,0.3); padding-top: 1rem; margin-top: 1rem;">
                        <div style="font-size: 1rem;">COST PER UNIT</div>
                        <div style="font-size: 2.5rem; font-weight: 700;">Rs. {{ number_format($production->cost_per_unit, 2) }}</div>
                        <div style="font-size: 0.875rem; opacity: 0.8;">per KG</div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Narration -->
        @if($production->narration)
        <div style="margin-top: 1.5rem; padding: 1rem; background: var(--light-bg); border-radius: 8px; border: 1px solid var(--border-color);">
            <label class="form-label text-muted"><i class="fas fa-sticky-note"></i> Narration</label>
            <div>{{ $production->narration }}</div>
        </div>
        @endif

        <!-- Meta Info -->
        <div style="margin-top: 1.5rem; font-size: 0.875rem; color: var(--secondary-color);">
            <i class="fas fa-user"></i> Created by: {{ $production->creator->name ?? 'System' }} |
            <i class="fas fa-clock"></i> Created: {{ $production->created_at->format('d-M-Y h:i A') }}
            @if($production->updated_at != $production->created_at)
                | <i class="fas fa-edit"></i> Updated: {{ $production->updated_at->format('d-M-Y h:i A') }}
            @endif
        </div>
    </div>
</div>

<style>
/* Mobile Responsive */
@media (max-width: 992px) {
    .production-tables {
        grid-template-columns: 1fr !important;
    }
    .summary-cards {
        grid-template-columns: repeat(2, 1fr) !important;
    }
}
@media (max-width: 576px) {
    .summary-cards {
        grid-template-columns: 1fr !important;
    }
    .production-tables table th,
    .production-tables table td {
        padding: 6px !important;
        font-size: 0.85rem;
    }
}
</style>
@endsection
