<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Production Batch: {{ $production->batch_no }}</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            line-height: 1.4;
            color: #333;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            text-align: center;
            border-bottom: 2px solid #333;
            padding-bottom: 15px;
            margin-bottom: 20px;
        }
        .header h1 {
            font-size: 24px;
            margin-bottom: 5px;
        }
        .header p {
            font-size: 11px;
            color: #666;
        }
        .title {
            text-align: center;
            font-size: 18px;
            font-weight: bold;
            margin-bottom: 20px;
            padding: 10px;
            background: #f0f0f0;
        }
        .info-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 15px;
            padding-bottom: 10px;
            border-bottom: 1px dashed #ccc;
        }
        .info-item {
            flex: 1;
        }
        .info-item label {
            font-size: 10px;
            color: #666;
            display: block;
        }
        .info-item span {
            font-weight: bold;
            font-size: 13px;
        }
        .section {
            margin-bottom: 20px;
        }
        .section-title {
            font-size: 14px;
            font-weight: bold;
            padding: 8px 10px;
            margin-bottom: 10px;
        }
        .section-title.input {
            background: #fff3e0;
            border-left: 4px solid #e65100;
        }
        .section-title.output {
            background: #e8f5e9;
            border-left: 4px solid #2e7d32;
        }
        .section-title.costs {
            background: #fce4ec;
            border-left: 4px solid #c2185b;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background: #f5f5f5;
            font-weight: bold;
            font-size: 11px;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .total-row {
            background: #f0f0f0;
            font-weight: bold;
        }
        .cost-summary {
            display: flex;
            gap: 20px;
        }
        .cost-breakdown {
            flex: 1;
        }
        .cost-per-unit {
            flex: 0 0 250px;
            text-align: center;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 20px;
            border-radius: 8px;
        }
        .cost-per-unit .label {
            font-size: 12px;
            opacity: 0.9;
        }
        .cost-per-unit .value {
            font-size: 28px;
            font-weight: bold;
            margin-top: 10px;
        }
        .cost-per-unit .unit {
            font-size: 11px;
            opacity: 0.8;
        }
        .footer {
            margin-top: 30px;
            padding-top: 15px;
            border-top: 1px solid #ccc;
            display: flex;
            justify-content: space-between;
        }
        .signature-box {
            width: 200px;
            text-align: center;
        }
        .signature-line {
            border-top: 1px solid #333;
            margin-top: 50px;
            padding-top: 5px;
            font-size: 11px;
        }
        @media print {
            body {
                print-color-adjust: exact;
                -webkit-print-color-adjust: exact;
            }
            .container {
                max-width: 100%;
                padding: 10px;
            }
            .no-print {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="no-print" style="margin-bottom: 20px;">
            <button onclick="window.print()" style="padding: 10px 20px; background: #007bff; color: white; border: none; cursor: pointer; border-radius: 4px;">
                🖨️ Print
            </button>
            <button onclick="window.close()" style="padding: 10px 20px; background: #6c757d; color: white; border: none; cursor: pointer; border-radius: 4px; margin-left: 10px;">
                ✕ Close
            </button>
        </div>

        <div class="header">
            <h1>USMAN BILAL Enterprises</h1>
            <p>Cotton Waste Processors & Dealers</p>
            <p>Main Susan Road Madina Town Faisalabad | Phone: 0300-6638044</p>
        </div>

        <div class="title">PRODUCTION BATCH REPORT</div>

        <div class="info-row">
            <div class="info-item">
                <label>Batch No</label>
                <span>{{ $production->batch_no }}</span>
            </div>
            <div class="info-item">
                <label>Date</label>
                <span>{{ $production->date->format('d-M-Y') }}</span>
            </div>
            <div class="info-item">
                <label>Machine/Process</label>
                <span>{{ $production->machine ?? '-' }}</span>
            </div>
            <div class="info-item">
                <label>Status</label>
                <span>{{ ucfirst($production->status) }}</span>
            </div>
        </div>

        @php
            $totalRawWeight = $production->inputItems->sum('quantity');
            $totalFinishWeight = $production->outputItems->sum('quantity');
            $totalWastageWeight = $production->wastageItems ? $production->wastageItems->sum('quantity') : 0;
            $totalFinishAmount = $production->outputItems->sum('amount');
        @endphp

        <!-- Side by Side Tables like Excel -->
        <div style="display: flex; gap: 15px; margin-bottom: 20px;">
            <!-- RAW MATERIAL Section -->
            <div style="flex: 1; border: 2px solid #dc3545;">
                <div style="background: #fff; padding: 8px; text-align: center; border-bottom: 2px solid #dc3545; font-weight: bold; color: #dc3545;">
                    RAW MATERIAL
                </div>
                <table style="margin: 0;">
                    <thead>
                        <tr>
                            <th>Description</th>
                            <th class="text-right" style="width: 70px;">Weight</th>
                            <th class="text-right" style="width: 50px;">%</th>
                            <th class="text-right" style="width: 60px;">Rate</th>
                            <th class="text-right" style="width: 80px;">Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($production->inputItems as $item)
                            @php
                                $percentage = $totalRawWeight > 0 ? ($item->quantity / $totalRawWeight) * 100 : 0;
                            @endphp
                            <tr>
                                <td>{{ $item->item->name }}</td>
                                <td class="text-right">{{ number_format($item->quantity, 0) }}</td>
                                <td class="text-right">{{ number_format($percentage, 2) }}</td>
                                <td class="text-right">{{ number_format($item->rate, 2) }}</td>
                                <td class="text-right">{{ number_format($item->amount, 0) }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        @if($totalWastageWeight > 0)
                        <tr style="background: #fff3cd;">
                            <td><strong>Panjee</strong></td>
                            <td class="text-right"><strong>{{ number_format($totalWastageWeight, 0) }}</strong></td>
                            <td colspan="3"></td>
                        </tr>
                        @endif
                        <tr class="total-row" style="background: #f8d7da;">
                            <td><strong>TOTAL</strong></td>
                            <td class="text-right"><strong>{{ number_format($totalRawWeight, 0) }}</strong></td>
                            <td class="text-right"><strong>100.00</strong></td>
                            <td></td>
                            <td class="text-right"><strong>{{ number_format($production->raw_material_cost, 0) }}</strong></td>
                        </tr>
                    </tfoot>
                </table>
            </div>

            <!-- FINISH MATERIAL Section -->
            <div style="flex: 1; border: 2px solid #28a745;">
                <div style="background: #ffff00; padding: 8px; text-align: center; border-bottom: 2px solid #28a745; font-weight: bold; color: #000;">
                    FINISH MATERIAL
                </div>
                <table style="margin: 0;">
                    <thead>
                        <tr>
                            <th>Description</th>
                            <th class="text-right" style="width: 70px;">Weight</th>
                            <th class="text-right" style="width: 60px;">Rate</th>
                            <th class="text-right" style="width: 80px;">Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($production->outputItems as $item)
                            <tr>
                                <td>{{ $item->item->name }}</td>
                                <td class="text-right">{{ number_format($item->quantity, 0) }}</td>
                                <td class="text-right">{{ number_format($item->rate, 2) }}</td>
                                <td class="text-right">{{ number_format($item->amount, 0) }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr style="background: #fff3cd;">
                            <td><strong>Panjee</strong></td>
                            <td class="text-right"><strong>{{ number_format($totalRawWeight, 0) }}</strong></td>
                            <td colspan="2"></td>
                        </tr>
                        <tr class="total-row" style="background: #d4edda;">
                            <td><strong>TOTAL</strong></td>
                            <td class="text-right"><strong>{{ number_format($totalFinishWeight, 0) }}</strong></td>
                            <td></td>
                            <td class="text-right"><strong>{{ number_format($totalFinishAmount, 0) }}</strong></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>

        <!-- Cost Summary -->
        <div class="section">
            <div class="section-title costs">💰 Production Cost Summary</div>
            <div class="cost-summary">
                <div class="cost-breakdown">
                    <table>
                        <tr>
                            <td>Raw Material Cost</td>
                            <td class="text-right">Rs. {{ number_format($production->raw_material_cost, 2) }}</td>
                        </tr>
                        <tr>
                            <td>Agent Commission</td>
                            <td class="text-right">Rs. {{ number_format($production->agent_commission, 2) }}</td>
                        </tr>
                        <tr>
                            <td>Transportation Cost</td>
                            <td class="text-right">Rs. {{ number_format($production->transportation_cost, 2) }}</td>
                        </tr>
                        <tr>
                            <td>Labor Cost</td>
                            <td class="text-right">Rs. {{ number_format($production->labor_cost, 2) }}</td>
                        </tr>
                        <tr>
                            <td>Electricity Cost</td>
                            <td class="text-right">Rs. {{ number_format($production->electricity_cost, 2) }}</td>
                        </tr>
                        <tr>
                            <td>Other Expenses</td>
                            <td class="text-right">Rs. {{ number_format($production->other_expenses, 2) }}</td>
                        </tr>
                        @if($production->other_expenses_description)
                        <tr>
                            <td colspan="2" style="font-size: 10px; color: #666;"><em>{{ $production->other_expenses_description }}</em></td>
                        </tr>
                        @endif
                        <tr class="total-row">
                            <td><strong>TOTAL PRODUCTION COST</strong></td>
                            <td class="text-right"><strong>Rs. {{ number_format($production->total_cost, 2) }}</strong></td>
                        </tr>
                    </table>
                </div>
                <div class="cost-per-unit">
                    <div class="label">CALCULATED</div>
                    <div class="label">COST PER UNIT</div>
                    <div class="value">Rs. {{ number_format($production->cost_per_unit, 2) }}</div>
                    <div class="unit">per KG</div>
                </div>
            </div>
        </div>

        @if($production->narration)
        <div class="section">
            <strong>Narration:</strong> {{ $production->narration }}
        </div>
        @endif

        <div class="footer">
            <div class="signature-box">
                <div class="signature-line">Prepared By</div>
            </div>
            <div class="signature-box">
                <div class="signature-line">Verified By</div>
            </div>
            <div class="signature-box">
                <div class="signature-line">Approved By</div>
            </div>
        </div>

        <div style="margin-top: 20px; font-size: 10px; color: #999; text-align: center;">
            Printed on: {{ now()->format('d-M-Y h:i A') }} | Created by: {{ $production->creator->name ?? 'System' }}
        </div>
    </div>
</body>
</html>
