@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-industry"></i> Production Batches</h3>
        <a href="{{ route('production.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> New Production
        </a>
    </div>
    <div class="card-body">
        @if(session('success'))
            <div style="background-color: #d4edda; border: 1px solid #c3e6cb; color: #155724; padding: 1rem; border-radius: 4px; margin-bottom: 1rem;">
                <i class="fas fa-check-circle"></i> {{ session('success') }}
            </div>
        @endif

        <!-- Summary Cards -->
        <div class="form-row mb-4">
            <div class="form-group" style="flex: 1;">
                <div style="background: linear-gradient(135deg, #e3f2fd 0%, #bbdefb 100%); padding: 1rem; border-radius: 8px; text-align: center;">
                    <div style="font-size: 0.85rem; color: #1565c0;">Total Batches</div>
                    <div style="font-size: 1.5rem; font-weight: 700; color: #0d47a1;">{{ $totals['count'] }}</div>
                </div>
            </div>
            <div class="form-group" style="flex: 1;">
                <div style="background: linear-gradient(135deg, #fff3e0 0%, #ffcc80 100%); padding: 1rem; border-radius: 8px; text-align: center;">
                    <div style="font-size: 0.85rem; color: #e65100;">Raw Material Cost</div>
                    <div style="font-size: 1.5rem; font-weight: 700; color: #bf360c;">Rs. {{ number_format($totals['raw_material'], 0) }}</div>
                </div>
            </div>
            <div class="form-group" style="flex: 1;">
                <div style="background: linear-gradient(135deg, #fce4ec 0%, #f8bbd9 100%); padding: 1rem; border-radius: 8px; text-align: center;">
                    <div style="font-size: 0.85rem; color: #c2185b;">Total Production Cost</div>
                    <div style="font-size: 1.5rem; font-weight: 700; color: #880e4f;">Rs. {{ number_format($totals['total_cost'], 0) }}</div>
                </div>
            </div>
            <div class="form-group" style="flex: 1;">
                <div style="background: linear-gradient(135deg, #e8f5e9 0%, #a5d6a7 100%); padding: 1rem; border-radius: 8px; text-align: center;">
                    <div style="font-size: 0.85rem; color: #2e7d32;">Output Quantity</div>
                    <div style="font-size: 1.5rem; font-weight: 700; color: #1b5e20;">{{ number_format($totals['output_qty'], 2) }} KG</div>
                </div>
            </div>
        </div>

        <!-- Filter Form -->
        <form method="GET" action="{{ route('production.index') }}" style="margin-bottom: 1rem;">
            <div class="form-row">
                <div class="form-group" style="flex: 0 0 150px;">
                    <label class="form-label">From Date</label>
                    <input type="date" class="form-control" name="from_date" value="{{ request('from_date') }}">
                </div>
                <div class="form-group" style="flex: 0 0 150px;">
                    <label class="form-label">To Date</label>
                    <input type="date" class="form-control" name="to_date" value="{{ request('to_date') }}">
                </div>
                <div class="form-group" style="flex: 1;">
                    <label class="form-label">Search</label>
                    <input type="text" class="form-control" name="search" value="{{ request('search') }}" placeholder="Batch No, Machine...">
                </div>
                <div class="form-group" style="flex: 0 0 auto; display: flex; align-items: flex-end;">
                    <button type="submit" class="btn btn-outline" style="margin-right: 0.5rem;"><i class="fas fa-search"></i> Filter</button>
                    <a href="{{ route('production.index') }}" class="btn btn-outline"><i class="fas fa-times"></i> Clear</a>
                </div>
            </div>
        </form>

        <div class="table-responsive">
            <table>
                <thead>
                    <tr>
                        <th>Batch No</th>
                        <th>Date</th>
                        <th>Machine</th>
                        <th class="text-right">Raw Material</th>
                        <th class="text-right">Other Costs</th>
                        <th class="text-right">Total Cost</th>
                        <th class="text-right">Output Qty</th>
                        <th class="text-right">Cost/Unit</th>
                        <th class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($productions as $production)
                        <tr>
                            <td>
                                <a href="{{ route('production.show', $production) }}" style="font-weight: 600; color: var(--primary-color);">
                                    {{ $production->batch_no }}
                                </a>
                            </td>
                            <td>{{ $production->date->format('d-M-Y') }}</td>
                            <td>{{ $production->machine ?? '-' }}</td>
                            <td class="text-right">Rs. {{ number_format($production->raw_material_cost, 2) }}</td>
                            <td class="text-right">Rs. {{ number_format($production->total_cost - $production->raw_material_cost, 2) }}</td>
                            <td class="text-right"><strong>Rs. {{ number_format($production->total_cost, 2) }}</strong></td>
                            <td class="text-right">{{ number_format($production->output_quantity, 2) }} KG</td>
                            <td class="text-right">
                                <strong style="color: var(--success-color);">Rs. {{ number_format($production->cost_per_unit, 2) }}</strong>
                            </td>
                            <td class="text-center">
                                <a href="{{ route('production.show', $production) }}" class="btn btn-outline" style="padding: 0.25rem 0.5rem;" title="View">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="{{ route('production.print', $production) }}" class="btn btn-outline" style="padding: 0.25rem 0.5rem;" title="Print" target="_blank">
                                    <i class="fas fa-print"></i>
                                </a>
                                <a href="{{ route('production.edit', $production) }}" class="btn btn-outline" style="padding: 0.25rem 0.5rem;" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form action="{{ route('production.destroy', $production) }}" method="POST" style="display: inline;" onsubmit="return confirm('Delete this production batch? Stock will be reversed.');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-outline" style="padding: 0.25rem 0.5rem; color: var(--danger-color);" title="Delete">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="9" class="text-center text-muted" style="padding: 3rem;">
                                <i class="fas fa-industry" style="font-size: 3rem; margin-bottom: 1rem; display: block; opacity: 0.3;"></i>
                                No production batches found. <a href="{{ route('production.create') }}">Create first production</a>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        @if($productions->hasPages())
            <div style="margin-top: 1rem;">
                {{ $productions->links() }}
            </div>
        @endif
    </div>
</div>
@endsection
