@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-edit"></i> Edit Production Costs: {{ $production->batch_no }}</h3>
        <a href="{{ route('production.show', $production) }}" class="btn btn-outline">
            <i class="fas fa-arrow-left"></i> Back
        </a>
    </div>
    <div class="card-body">
        @if($errors->any())
            <div style="background-color: #f8d7da; border: 1px solid #f5c6cb; color: #721c24; padding: 1rem; border-radius: 4px; margin-bottom: 1rem;">
                <strong><i class="fas fa-exclamation-triangle"></i> Please fix the following errors:</strong>
                <ul style="margin: 0.5rem 0 0 1.5rem;">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        @if(session('error'))
            <div style="background-color: #f8d7da; border: 1px solid #f5c6cb; color: #721c24; padding: 1rem; border-radius: 4px; margin-bottom: 1rem;">
                <i class="fas fa-exclamation-circle"></i> {{ session('error') }}
            </div>
        @endif

        <div style="background: #e3f2fd; padding: 1rem; border-radius: 8px; margin-bottom: 1.5rem; border: 1px solid #90caf9;">
            <i class="fas fa-info-circle"></i> <strong>Note:</strong> You can only edit the additional production costs. 
            Raw materials and output quantities cannot be changed. To modify those, delete this batch and create a new one.
        </div>

        <form action="{{ route('production.update', $production) }}" method="POST">
            @csrf
            @method('PUT')

            <!-- Production Header -->
            <div class="form-row">
                <div class="form-group" style="flex: 0 0 180px;">
                    <label class="form-label">Batch No</label>
                    <input type="text" class="form-control" value="{{ $production->batch_no }}" readonly style="background-color: #f8f9fa; font-weight: 600;">
                </div>
                <div class="form-group" style="flex: 0 0 180px;">
                    <label class="form-label" for="date">Date <span class="text-danger">*</span></label>
                    <input type="date" class="form-control" id="date" name="date" value="{{ old('date', $production->date->format('Y-m-d')) }}" required>
                </div>
                <div class="form-group" style="flex: 1;">
                    <label class="form-label" for="machine">Machine / Process</label>
                    <input type="text" class="form-control" id="machine" name="machine" value="{{ old('machine', $production->machine) }}">
                </div>
            </div>

            <!-- Raw Materials Summary (Read Only) -->
            <div style="background: #fff3e0; padding: 1rem; border-radius: 8px; margin-bottom: 1.5rem; border: 1px solid #ffcc80;">
                <h4 style="margin: 0 0 1rem 0; color: #e65100;"><i class="fas fa-arrow-right"></i> Raw Materials Input (Read Only)</h4>
                
                <table style="width: 100%; border: 1px solid #ffcc80;">
                    <thead>
                        <tr style="background: #ffe0b2;">
                            <th>#</th>
                            <th>Item</th>
                            <th class="text-right">Quantity</th>
                            <th class="text-right">Rate</th>
                            <th class="text-right">Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($production->inputItems as $index => $item)
                            <tr>
                                <td>{{ $index + 1 }}</td>
                                <td>{{ $item->item->name }}</td>
                                <td class="text-right">{{ number_format($item->quantity, 3) }} {{ $item->item->unit }}</td>
                                <td class="text-right">Rs. {{ number_format($item->rate, 2) }}</td>
                                <td class="text-right">Rs. {{ number_format($item->amount, 2) }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr style="background: #ffe0b2;">
                            <td colspan="4" class="text-right"><strong>Total Raw Material Cost:</strong></td>
                            <td class="text-right"><strong>Rs. {{ number_format($production->raw_material_cost, 2) }}</strong></td>
                        </tr>
                    </tfoot>
                </table>
            </div>

            <!-- Output Summary (Read Only) -->
            <div style="background: #e8f5e9; padding: 1rem; border-radius: 8px; margin-bottom: 1.5rem; border: 1px solid #a5d6a7;">
                <h4 style="margin: 0 0 1rem 0; color: #2e7d32;"><i class="fas fa-arrow-left"></i> Finished Goods Output (Read Only)</h4>
                
                <table style="width: 100%; border: 1px solid #a5d6a7;">
                    <thead>
                        <tr style="background: #c8e6c9;">
                            <th>#</th>
                            <th>Item</th>
                            <th class="text-right">Quantity</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($production->outputItems as $index => $item)
                            <tr>
                                <td>{{ $index + 1 }}</td>
                                <td>{{ $item->item->name }}</td>
                                <td class="text-right">{{ number_format($item->quantity, 3) }} {{ $item->item->unit }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr style="background: #c8e6c9;">
                            <td colspan="2" class="text-right"><strong>Total Output:</strong></td>
                            <td class="text-right"><strong>{{ number_format($production->output_quantity, 3) }} KG</strong></td>
                        </tr>
                    </tfoot>
                </table>
            </div>

            <!-- Editable Additional Costs -->
            <div style="background: #fce4ec; padding: 1rem; border-radius: 8px; margin-bottom: 1.5rem; border: 1px solid #f8bbd9;">
                <h4 style="margin: 0 0 1rem 0; color: #c2185b;"><i class="fas fa-coins"></i> Additional Production Costs (Editable)</h4>
                
                <div class="form-row">
                    <div class="form-group" style="flex: 1;">
                        <label class="form-label" for="agent_commission">Agent Commission</label>
                        <input type="number" class="form-control cost-input" id="agent_commission" name="agent_commission" step="0.01" min="0" value="{{ old('agent_commission', $production->agent_commission) }}">
                    </div>
                    <div class="form-group" style="flex: 1;">
                        <label class="form-label" for="transportation_cost">Transportation Cost</label>
                        <input type="number" class="form-control cost-input" id="transportation_cost" name="transportation_cost" step="0.01" min="0" value="{{ old('transportation_cost', $production->transportation_cost) }}">
                    </div>
                    <div class="form-group" style="flex: 1;">
                        <label class="form-label" for="labor_cost">Labor Cost</label>
                        <input type="number" class="form-control cost-input" id="labor_cost" name="labor_cost" step="0.01" min="0" value="{{ old('labor_cost', $production->labor_cost) }}">
                    </div>
                    <div class="form-group" style="flex: 1;">
                        <label class="form-label" for="electricity_cost">Electricity Cost</label>
                        <input type="number" class="form-control cost-input" id="electricity_cost" name="electricity_cost" step="0.01" min="0" value="{{ old('electricity_cost', $production->electricity_cost) }}">
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group" style="flex: 0 0 200px;">
                        <label class="form-label" for="other_expenses">Other Expenses</label>
                        <input type="number" class="form-control cost-input" id="other_expenses" name="other_expenses" step="0.01" min="0" value="{{ old('other_expenses', $production->other_expenses) }}">
                    </div>
                    <div class="form-group" style="flex: 1;">
                        <label class="form-label" for="other_expenses_description">Other Expenses Description</label>
                        <input type="text" class="form-control" id="other_expenses_description" name="other_expenses_description" value="{{ old('other_expenses_description', $production->other_expenses_description) }}">
                    </div>
                </div>
            </div>

            <!-- Live Cost Calculation -->
            <div style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 1.5rem; border-radius: 8px; margin-bottom: 1.5rem; color: white;">
                <h4 style="margin: 0 0 1rem 0;"><i class="fas fa-calculator"></i> Updated Cost Calculation</h4>
                
                <div class="form-row" style="justify-content: space-between;">
                    <div style="text-align: center; flex: 1;">
                        <div style="font-size: 0.875rem; opacity: 0.9;">Raw Material Cost</div>
                        <div style="font-size: 1.5rem; font-weight: 700;">Rs. {{ number_format($production->raw_material_cost, 2) }}</div>
                    </div>
                    <div style="text-align: center; flex: 1;">
                        <div style="font-size: 0.875rem; opacity: 0.9;">Additional Costs</div>
                        <div style="font-size: 1.5rem; font-weight: 700;" id="additionalCostsDisplay">Rs. {{ number_format($production->total_cost - $production->raw_material_cost, 2) }}</div>
                    </div>
                    <div style="text-align: center; flex: 1;">
                        <div style="font-size: 0.875rem; opacity: 0.9;">Total Cost</div>
                        <div style="font-size: 1.75rem; font-weight: 700;" id="totalCostDisplay">Rs. {{ number_format($production->total_cost, 2) }}</div>
                    </div>
                    <div style="text-align: center; flex: 1;">
                        <div style="font-size: 0.875rem; opacity: 0.9;">Output Qty</div>
                        <div style="font-size: 1.5rem; font-weight: 700;">{{ number_format($production->output_quantity, 3) }} KG</div>
                    </div>
                    <div style="text-align: center; flex: 1; background: rgba(255,255,255,0.2); padding: 0.5rem; border-radius: 8px;">
                        <div style="font-size: 0.875rem;">NEW COST/UNIT</div>
                        <div style="font-size: 2rem; font-weight: 700;" id="costPerUnitDisplay">Rs. {{ number_format($production->cost_per_unit, 2) }}</div>
                    </div>
                </div>
            </div>

            <!-- Narration -->
            <div class="form-group">
                <label class="form-label" for="narration">Narration / Notes</label>
                <textarea class="form-control" id="narration" name="narration" rows="2">{{ old('narration', $production->narration) }}</textarea>
            </div>

            <div style="display: flex; gap: 0.5rem; margin-top: 1.5rem; padding-top: 1rem; border-top: 1px solid var(--border-color);">
                <button type="submit" class="btn btn-success">
                    <i class="fas fa-save"></i> Update Production
                </button>
                <a href="{{ route('production.show', $production) }}" class="btn btn-outline">
                    <i class="fas fa-times"></i> Cancel
                </a>
            </div>
        </form>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const rawMaterialCost = {{ $production->raw_material_cost }};
    const outputQuantity = {{ $production->output_quantity }};

    function calculateCosts() {
        const agentCommission = parseFloat(document.getElementById('agent_commission').value) || 0;
        const transportCost = parseFloat(document.getElementById('transportation_cost').value) || 0;
        const laborCost = parseFloat(document.getElementById('labor_cost').value) || 0;
        const electricityCost = parseFloat(document.getElementById('electricity_cost').value) || 0;
        const otherExpenses = parseFloat(document.getElementById('other_expenses').value) || 0;

        const additionalCosts = agentCommission + transportCost + laborCost + electricityCost + otherExpenses;
        const totalCost = rawMaterialCost + additionalCosts;
        const costPerUnit = outputQuantity > 0 ? totalCost / outputQuantity : 0;

        document.getElementById('additionalCostsDisplay').textContent = 'Rs. ' + additionalCosts.toFixed(2);
        document.getElementById('totalCostDisplay').textContent = 'Rs. ' + totalCost.toFixed(2);
        document.getElementById('costPerUnitDisplay').textContent = 'Rs. ' + costPerUnit.toFixed(2);
    }

    document.querySelectorAll('.cost-input').forEach(input => {
        input.addEventListener('input', calculateCosts);
    });
});
</script>
@endsection
