@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-users"></i> Parties (Customers & Suppliers)</h3>
        <a href="{{ route('parties.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> New Party
        </a>
    </div>
    <div class="card-body">
        @if(session('success'))
            <div class="alert" style="background-color: #d4edda; border: 1px solid #c3e6cb; color: #155724; padding: 1rem; border-radius: 4px; margin-bottom: 1rem;">
                <i class="fas fa-check-circle"></i> {{ session('success') }}
            </div>
        @endif
        @if(session('error'))
            <div class="alert" style="background-color: #f8d7da; border: 1px solid #f5c6cb; color: #721c24; padding: 1rem; border-radius: 4px; margin-bottom: 1rem;">
                <i class="fas fa-exclamation-circle"></i> {{ session('error') }}
            </div>
        @endif

        <!-- Filters -->
        <form method="GET" action="{{ route('parties.index') }}">
            <div class="form-row mb-4">
                <div class="form-group" style="flex: 0 0 200px;">
                    <label class="form-label">Filter by Type</label>
                    <select class="form-control" name="type" onchange="this.form.submit()">
                        <option value="">All Types</option>
                        @foreach($types as $key => $label)
                            <option value="{{ $key }}" {{ request('type') == $key ? 'selected' : '' }}>{{ $label }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="form-group" style="flex: 1;">
                    <label class="form-label">Search</label>
                    <input type="text" class="form-control" name="search" value="{{ request('search') }}" placeholder="Search by code, name, phone or city...">
                </div>
                <div class="form-group" style="flex: 0 0 auto; display: flex; align-items: flex-end;">
                    <button type="submit" class="btn btn-outline" style="margin-right: 0.5rem;"><i class="fas fa-search"></i> Search</button>
                    <a href="{{ route('parties.index') }}" class="btn btn-outline"><i class="fas fa-times"></i> Clear</a>
                </div>
            </div>
        </form>

        <!-- Summary Cards -->
        <div class="form-row mb-4">
            @php
                $customers = $parties->where('type', 'customer')->count() + $parties->where('type', 'both')->count();
                $suppliers = $parties->where('type', 'supplier')->count() + $parties->where('type', 'both')->count();
                $totalReceivable = $parties->whereIn('type', ['customer', 'both'])->sum('current_balance');
                $totalPayable = $parties->whereIn('type', ['supplier', 'both'])->sum('current_balance');
            @endphp
            <div class="form-group" style="flex: 1;">
                <div style="background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%); padding: 1rem; border-radius: 8px; text-align: center;">
                    <div style="font-size: 0.85rem; color: #155724;">Customers</div>
                    <div style="font-size: 1.5rem; font-weight: 700; color: #155724;">{{ $customers }}</div>
                </div>
            </div>
            <div class="form-group" style="flex: 1;">
                <div style="background: linear-gradient(135deg, #cce5ff 0%, #b8daff 100%); padding: 1rem; border-radius: 8px; text-align: center;">
                    <div style="font-size: 0.85rem; color: #004085;">Suppliers</div>
                    <div style="font-size: 1.5rem; font-weight: 700; color: #004085;">{{ $suppliers }}</div>
                </div>
            </div>
            <div class="form-group" style="flex: 1;">
                <div style="background: linear-gradient(135deg, #fff3cd 0%, #ffc107 100%); padding: 1rem; border-radius: 8px; text-align: center;">
                    <div style="font-size: 0.85rem; color: #856404;">Total Receivable</div>
                    <div style="font-size: 1.25rem; font-weight: 700; color: #856404;">Rs. {{ number_format($totalReceivable, 2) }}</div>
                </div>
            </div>
            <div class="form-group" style="flex: 1;">
                <div style="background: linear-gradient(135deg, #f8d7da 0%, #f5c6cb 100%); padding: 1rem; border-radius: 8px; text-align: center;">
                    <div style="font-size: 0.85rem; color: #721c24;">Total Payable</div>
                    <div style="font-size: 1.25rem; font-weight: 700; color: #721c24;">Rs. {{ number_format($totalPayable, 2) }}</div>
                </div>
            </div>
        </div>

        <div class="table-responsive">
            <table>
                <thead>
                    <tr>
                        <th>Code</th>
                        <th>Party Name</th>
                        <th>Type</th>
                        <th>Phone</th>
                        <th>City</th>
                        <th class="text-right">Credit Limit</th>
                        <th class="text-right">Balance</th>
                        <th class="text-center">Status</th>
                        <th class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($parties as $party)
                        <tr>
                            <td><strong>{{ $party->code }}</strong></td>
                            <td>{{ $party->name }}</td>
                            <td>
                                @php
                                    $typeColors = ['customer' => '#28a745', 'supplier' => '#007bff', 'both' => '#6f42c1'];
                                @endphp
                                <span style="background-color: {{ $typeColors[$party->type] ?? '#6c757d' }}; color: white; padding: 0.25rem 0.5rem; border-radius: 4px; font-size: 0.75rem;">
                                    {{ $types[$party->type] ?? ucfirst($party->type) }}
                                </span>
                            </td>
                            <td>{{ $party->phone ?: $party->mobile ?: '-' }}</td>
                            <td>{{ $party->city ?: '-' }}</td>
                            <td class="text-right">
                                {{ $party->credit_limit ? 'Rs. ' . number_format($party->credit_limit, 2) : '-' }}
                            </td>
                            <td class="text-right" style="font-weight: 600;">
                                Rs. {{ number_format($party->current_balance, 2) }}
                            </td>
                            <td class="text-center">
                                @if($party->is_active)
                                    <span style="background-color: #28a745; color: white; padding: 0.2rem 0.5rem; border-radius: 4px; font-size: 0.7rem;">Active</span>
                                @else
                                    <span style="background-color: #6c757d; color: white; padding: 0.2rem 0.5rem; border-radius: 4px; font-size: 0.7rem;">Inactive</span>
                                @endif
                            </td>
                            <td class="text-center">
                                <a href="{{ route('parties.show', $party) }}" class="btn btn-outline" style="padding: 0.25rem 0.5rem;" title="View">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="{{ route('parties.edit', $party) }}" class="btn btn-outline" style="padding: 0.25rem 0.5rem;" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form action="{{ route('parties.destroy', $party) }}" method="POST" style="display: inline;">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-outline" style="padding: 0.25rem 0.5rem; color: var(--danger-color);" onclick="return confirm('Are you sure you want to delete this party?')" title="Delete">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="9" class="text-center text-muted" style="padding: 3rem;">
                                <i class="fas fa-users" style="font-size: 3rem; display: block; margin-bottom: 1rem; opacity: 0.5;"></i>
                                <p style="margin: 0;">No parties found. <a href="{{ route('parties.create') }}">Create your first party</a></p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div style="margin-top: 1rem; display: flex; justify-content: space-between; align-items: center;">
            <span style="color: #6c757d;">Total: {{ $parties->count() }} parties</span>
        </div>
    </div>
</div>
@endsection
