@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-edit"></i> Edit Party: {{ $party->name }}</h3>
        <a href="{{ route('parties.index') }}" class="btn btn-outline">
            <i class="fas fa-arrow-left"></i> Back
        </a>
    </div>
    <div class="card-body">
        @if($errors->any())
            <div style="background-color: #f8d7da; border: 1px solid #f5c6cb; color: #721c24; padding: 1rem; border-radius: 4px; margin-bottom: 1rem;">
                <strong><i class="fas fa-exclamation-triangle"></i> Please fix the following errors:</strong>
                <ul style="margin: 0.5rem 0 0 1.5rem;">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form action="{{ route('parties.update', $party) }}" method="POST">
            @csrf
            @method('PUT')
            
            <div class="form-row">
                <div class="form-group" style="flex: 0 0 150px;">
                    <label class="form-label">Party Code</label>
                    <input type="text" class="form-control" value="{{ $party->code }}" readonly style="background-color: #e9ecef;">
                </div>

                <div class="form-group">
                    <label class="form-label" for="name">Party Name <span class="text-danger">*</span></label>
                    <input type="text" class="form-control @error('name') is-invalid @enderror" 
                           id="name" name="name" value="{{ old('name', $party->name) }}" 
                           placeholder="e.g., ABC Trading Company" required>
                    @error('name')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group">
                    <label class="form-label" for="type">Party Type <span class="text-danger">*</span></label>
                    <select class="form-control @error('type') is-invalid @enderror" 
                            id="type" name="type" required>
                        <option value="">Select Type</option>
                        @foreach($types as $key => $value)
                            <option value="{{ $key }}" {{ old('type', $party->type) == $key ? 'selected' : '' }}>
                                {{ $value }}
                            </option>
                        @endforeach
                    </select>
                    @error('type')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label class="form-label" for="phone">Phone</label>
                    <input type="text" class="form-control @error('phone') is-invalid @enderror" 
                           id="phone" name="phone" value="{{ old('phone', $party->phone) }}" 
                           placeholder="e.g., 042-12345678">
                    @error('phone')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group">
                    <label class="form-label" for="mobile">Mobile</label>
                    <input type="text" class="form-control @error('mobile') is-invalid @enderror" 
                           id="mobile" name="mobile" value="{{ old('mobile', $party->mobile) }}" 
                           placeholder="e.g., 0300-1234567">
                    @error('mobile')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label class="form-label" for="email">Email</label>
                    <input type="email" class="form-control @error('email') is-invalid @enderror" 
                           id="email" name="email" value="{{ old('email', $party->email) }}" 
                           placeholder="e.g., info@company.com">
                    @error('email')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group">
                    <label class="form-label" for="city">City</label>
                    <input type="text" class="form-control @error('city') is-invalid @enderror" 
                           id="city" name="city" value="{{ old('city', $party->city) }}" 
                           placeholder="e.g., Lahore">
                    @error('city')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>
            </div>

            <div class="form-group">
                <label class="form-label" for="address">Address</label>
                <textarea class="form-control @error('address') is-invalid @enderror" 
                          id="address" name="address" rows="2" 
                          placeholder="Full address...">{{ old('address', $party->address) }}</textarea>
                @error('address')
                    <span class="error-message">{{ $message }}</span>
                @enderror
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label class="form-label" for="ntn">NTN Number</label>
                    <input type="text" class="form-control @error('ntn') is-invalid @enderror" 
                           id="ntn" name="ntn" value="{{ old('ntn', $party->ntn) }}" 
                           placeholder="e.g., 1234567-8">
                    @error('ntn')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group">
                    <label class="form-label" for="cnic">CNIC</label>
                    <input type="text" class="form-control @error('cnic') is-invalid @enderror" 
                           id="cnic" name="cnic" value="{{ old('cnic', $party->cnic) }}" 
                           placeholder="e.g., 12345-1234567-1">
                    @error('cnic')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label class="form-label" for="credit_limit">Credit Limit</label>
                    <input type="number" class="form-control @error('credit_limit') is-invalid @enderror" 
                           id="credit_limit" name="credit_limit" value="{{ old('credit_limit', $party->credit_limit) }}" 
                           step="0.01" min="0">
                    @error('credit_limit')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group">
                    <label class="form-label" for="credit_days">Credit Days</label>
                    <input type="number" class="form-control @error('credit_days') is-invalid @enderror" 
                           id="credit_days" name="credit_days" value="{{ old('credit_days', $party->credit_days) }}" 
                           min="0">
                    @error('credit_days')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label class="form-label" for="opening_balance">Opening Balance</label>
                    <input type="number" class="form-control @error('opening_balance') is-invalid @enderror" 
                           id="opening_balance" name="opening_balance" 
                           value="{{ old('opening_balance', $party->opening_balance) }}" step="0.01" min="0">
                    @error('opening_balance')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group">
                    <label class="form-label" for="opening_type">Balance Type</label>
                    <select class="form-control @error('opening_type') is-invalid @enderror" id="opening_type" name="opening_type">
                        <option value="debit" {{ old('opening_type', $party->opening_type) == 'debit' ? 'selected' : '' }}>Debit (Receivable)</option>
                        <option value="credit" {{ old('opening_type', $party->opening_type) == 'credit' ? 'selected' : '' }}>Credit (Payable)</option>
                    </select>
                    @error('opening_type')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>
            </div>

            <div class="form-row">
                <div class="form-group" style="flex: 0 0 auto;">
                    <label class="form-label" style="display: block; margin-bottom: 0.75rem;">&nbsp;</label>
                    <label style="display: flex; align-items: center; gap: 0.5rem; cursor: pointer;">
                        <input type="checkbox" name="is_active" value="1" 
                               {{ old('is_active', $party->is_active) ? 'checked' : '' }}
                               style="width: 18px; height: 18px;">
                        <span>Active</span>
                    </label>
                </div>
            </div>

            <div style="background-color: #f8f9fa; padding: 1rem; border-radius: 4px; margin-top: 1rem; margin-bottom: 1rem;">
                <div class="form-row" style="margin-bottom: 0;">
                    <div class="form-group" style="margin-bottom: 0;">
                        <label class="form-label" style="color: #6c757d;">Current Balance</label>
                        <div style="font-size: 1.5rem; font-weight: 700; color: var(--primary-color);">
                            Rs. {{ number_format($party->current_balance, 2) }}
                        </div>
                    </div>
                    <div class="form-group" style="margin-bottom: 0;">
                        <label class="form-label" style="color: #6c757d;">Created At</label>
                        <div>{{ $party->created_at->format('d M Y, h:i A') }}</div>
                    </div>
                    <div class="form-group" style="margin-bottom: 0;">
                        <label class="form-label" style="color: #6c757d;">Last Updated</label>
                        <div>{{ $party->updated_at->format('d M Y, h:i A') }}</div>
                    </div>
                </div>
            </div>

            <div style="display: flex; gap: 0.5rem; margin-top: 1.5rem;">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Update Party
                </button>
                <a href="{{ route('parties.show', $party) }}" class="btn btn-outline">
                    <i class="fas fa-eye"></i> View
                </a>
                <a href="{{ route('parties.index') }}" class="btn btn-outline">
                    Cancel
                </a>
            </div>
        </form>
    </div>
</div>
@endsection
