<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'AccSoft') }} - Login</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=inter:400,500,600,700&display=swap" rel="stylesheet" />
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', sans-serif;
            min-height: 100vh;
            display: flex;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }

        .auth-container {
            display: flex;
            width: 100%;
            min-height: 100vh;
        }

        .auth-left {
            flex: 1;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            padding: 2rem;
            color: white;
            text-align: center;
        }

        .auth-left .logo {
            font-size: 3rem;
            margin-bottom: 1rem;
        }

        .auth-left h1 {
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
        }

        .auth-left p {
            font-size: 1.125rem;
            opacity: 0.9;
            max-width: 400px;
        }

        .auth-features {
            margin-top: 3rem;
            text-align: left;
        }

        .auth-feature {
            display: flex;
            align-items: center;
            gap: 1rem;
            margin-bottom: 1.25rem;
            font-size: 1rem;
        }

        .auth-feature i {
            width: 40px;
            height: 40px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 0.5rem;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .auth-right {
            width: 100%;
            max-width: 480px;
            background: white;
            display: flex;
            flex-direction: column;
            justify-content: center;
            padding: 3rem;
        }

        .auth-form-header {
            margin-bottom: 2rem;
        }

        .auth-form-header h2 {
            font-size: 1.75rem;
            font-weight: 700;
            color: #1e293b;
            margin-bottom: 0.5rem;
        }

        .auth-form-header p {
            color: #64748b;
        }

        .form-group {
            margin-bottom: 1.25rem;
        }

        .form-label {
            display: block;
            margin-bottom: 0.5rem;
            font-size: 0.875rem;
            font-weight: 500;
            color: #1e293b;
        }

        .form-control {
            width: 100%;
            padding: 0.75rem 1rem;
            font-size: 0.9375rem;
            border: 1px solid #e2e8f0;
            border-radius: 0.5rem;
            transition: all 0.2s;
            background-color: #f8fafc;
        }

        .form-control:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.15);
            background-color: white;
        }

        .form-control::placeholder {
            color: #94a3b8;
        }

        .input-group {
            position: relative;
        }

        .input-group i {
            position: absolute;
            left: 1rem;
            top: 50%;
            transform: translateY(-50%);
            color: #94a3b8;
        }

        .input-group .form-control {
            padding-left: 2.75rem;
        }

        .form-check {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            margin-bottom: 1.5rem;
        }

        .form-check input[type="checkbox"] {
            width: 18px;
            height: 18px;
            accent-color: #667eea;
        }

        .form-check label {
            font-size: 0.875rem;
            color: #64748b;
        }

        .forgot-link {
            margin-left: auto;
            font-size: 0.875rem;
            color: #667eea;
            text-decoration: none;
        }

        .forgot-link:hover {
            text-decoration: underline;
        }

        .btn-login {
            width: 100%;
            padding: 0.875rem;
            font-size: 1rem;
            font-weight: 600;
            color: white;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 0.5rem;
            cursor: pointer;
            transition: all 0.2s;
        }

        .btn-login:hover {
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(102, 126, 234, 0.4);
        }

        .btn-login:active {
            transform: translateY(0);
        }

        .divider {
            display: flex;
            align-items: center;
            margin: 1.5rem 0;
            color: #94a3b8;
            font-size: 0.875rem;
        }

        .divider::before,
        .divider::after {
            content: '';
            flex: 1;
            height: 1px;
            background-color: #e2e8f0;
        }

        .divider span {
            padding: 0 1rem;
        }

        .auth-footer {
            margin-top: 2rem;
            text-align: center;
            color: #64748b;
            font-size: 0.875rem;
        }

        .auth-footer a {
            color: #667eea;
            text-decoration: none;
            font-weight: 500;
        }

        .auth-footer a:hover {
            text-decoration: underline;
        }

        .alert {
            padding: 0.875rem 1rem;
            border-radius: 0.5rem;
            margin-bottom: 1.25rem;
            font-size: 0.875rem;
        }

        .alert-danger {
            background-color: #fee2e2;
            color: #991b1b;
            border: 1px solid #fecaca;
        }

        .alert-success {
            background-color: #dcfce7;
            color: #166534;
            border: 1px solid #86efac;
        }

        .error-message {
            color: #dc2626;
            font-size: 0.8125rem;
            margin-top: 0.375rem;
        }

        /* Company info in login */
        .company-select {
            margin-bottom: 1.5rem;
            padding: 1rem;
            background: #f0f4ff;
            border-radius: 0.5rem;
            border: 1px solid #e0e7ff;
        }

        .company-select label {
            display: block;
            font-size: 0.875rem;
            font-weight: 500;
            color: #4338ca;
            margin-bottom: 0.5rem;
        }

        .company-select select {
            width: 100%;
            padding: 0.625rem 0.75rem;
            border: 1px solid #c7d2fe;
            border-radius: 0.375rem;
            font-size: 0.875rem;
            background-color: white;
        }

        @media (max-width: 768px) {
            .auth-left {
                display: none;
            }

            .auth-right {
                max-width: 100%;
            }
        }

        @media (max-width: 480px) {
            .auth-right {
                padding: 1.5rem;
            }
        }
    </style>
</head>
<body>
    <div class="auth-container">
        <div class="auth-left">
            <div class="logo">
                <i class="fas fa-calculator"></i>
            </div>
            <h1>AccSoft</h1>
            <p>Complete Accounting Solution for Your Business</p>

            <div class="auth-features">
                <div class="auth-feature">
                    <i class="fas fa-file-invoice-dollar"></i>
                    <span>Purchase & Sales Management</span>
                </div>
                <div class="auth-feature">
                    <i class="fas fa-book"></i>
                    <span>Voucher & Journal Entries</span>
                </div>
                <div class="auth-feature">
                    <i class="fas fa-chart-pie"></i>
                    <span>Financial Reports & Analysis</span>
                </div>
                <div class="auth-feature">
                    <i class="fas fa-warehouse"></i>
                    <span>Inventory & Stock Management</span>
                </div>
                <div class="auth-feature">
                    <i class="fas fa-users"></i>
                    <span>Multi-User Access Control</span>
                </div>
            </div>
        </div>

        <div class="auth-right">
            @yield('content')
        </div>
    </div>
</body>
</html>
