@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-eye"></i> Item Details: {{ $item->name }}</h3>
        <div>
            <a href="{{ route('items.edit', $item) }}" class="btn btn-primary" style="margin-right: 0.5rem;">
                <i class="fas fa-edit"></i> Edit
            </a>
            <a href="{{ route('items.index') }}" class="btn btn-outline">
                <i class="fas fa-arrow-left"></i> Back
            </a>
        </div>
    </div>
    <div class="card-body">
        <!-- Item Info Cards -->
        <div class="form-row mb-4">
            <div class="form-group" style="flex: 1;">
                <div style="background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%); padding: 1.5rem; border-radius: 8px; height: 100%;">
                    <div style="font-size: 0.85rem; color: #6c757d; margin-bottom: 0.5rem;">Item Code</div>
                    <div style="font-size: 1.5rem; font-weight: 700; color: var(--primary-color);">{{ $item->code }}</div>
                </div>
            </div>
            <div class="form-group" style="flex: 2;">
                <div style="background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%); padding: 1.5rem; border-radius: 8px; height: 100%;">
                    <div style="font-size: 0.85rem; color: #6c757d; margin-bottom: 0.5rem;">Item Name</div>
                    <div style="font-size: 1.5rem; font-weight: 700;">{{ $item->name }}</div>
                </div>
            </div>
            <div class="form-group" style="flex: 1;">
                @php
                    $isLowStock = $item->current_stock <= $item->minimum_stock && $item->minimum_stock > 0;
                @endphp
                <div style="background: linear-gradient(135deg, {{ $isLowStock ? '#f8d7da' : '#d4edda' }} 0%, {{ $isLowStock ? '#f5c6cb' : '#c3e6cb' }} 100%); padding: 1.5rem; border-radius: 8px; height: 100%;">
                    <div style="font-size: 0.85rem; color: {{ $isLowStock ? '#721c24' : '#155724' }}; margin-bottom: 0.5rem;">
                        Current Stock
                        @if($isLowStock)
                            <i class="fas fa-exclamation-triangle"></i>
                        @endif
                    </div>
                    <div style="font-size: 1.5rem; font-weight: 700; color: {{ $isLowStock ? '#721c24' : '#155724' }};">
                        {{ number_format($item->current_stock, 2) }} {{ $item->unit }}
                    </div>
                </div>
            </div>
        </div>

        <!-- Item Details -->
        <div class="form-row">
            <div class="form-group" style="flex: 1;">
                <div style="border: 1px solid #dee2e6; border-radius: 8px; padding: 1rem;">
                    <h4 style="margin: 0 0 1rem 0; padding-bottom: 0.5rem; border-bottom: 1px solid #dee2e6;">
                        <i class="fas fa-info-circle"></i> Item Information
                    </h4>
                    <table style="width: 100%;">
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d; width: 40%;">Type:</td>
                            <td style="padding: 0.5rem 0; font-weight: 500;">
                                @php
                                    $typeLabels = ['raw' => 'RAW Material', 'finish' => 'FINISH Product'];
                                    $typeColors = ['raw' => ['#fef3c7', '#92400e'], 'finish' => ['#dcfce7', '#166534']];
                                @endphp
                                <span style="background-color: {{ $typeColors[$item->type][0] ?? '#e9ecef' }}; color: {{ $typeColors[$item->type][1] ?? '#212529' }}; padding: 0.25rem 0.5rem; border-radius: 4px; font-size: 0.85rem; font-weight: 600;">
                                    {{ $typeLabels[$item->type] ?? strtoupper($item->type) }}
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d;">Unit:</td>
                            <td style="padding: 0.5rem 0;">{{ $item->unit }}</td>
                        </tr>
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d;">Description:</td>
                            <td style="padding: 0.5rem 0;">{{ $item->description ?: '-' }}</td>
                        </tr>
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d;">Status:</td>
                            <td style="padding: 0.5rem 0;">
                                @if($item->is_active)
                                    <span style="background-color: #28a745; color: white; padding: 0.2rem 0.5rem; border-radius: 4px; font-size: 0.8rem;">Active</span>
                                @else
                                    <span style="background-color: #6c757d; color: white; padding: 0.2rem 0.5rem; border-radius: 4px; font-size: 0.8rem;">Inactive</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d;">Created:</td>
                            <td style="padding: 0.5rem 0;">{{ $item->created_at->format('d M Y, h:i A') }}</td>
                        </tr>
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d;">Last Updated:</td>
                            <td style="padding: 0.5rem 0;">{{ $item->updated_at->format('d M Y, h:i A') }}</td>
                        </tr>
                    </table>
                </div>
            </div>
            
            <div class="form-group" style="flex: 1;">
                <div style="border: 1px solid #dee2e6; border-radius: 8px; padding: 1rem;">
                    <h4 style="margin: 0 0 1rem 0; padding-bottom: 0.5rem; border-bottom: 1px solid #dee2e6;">
                        <i class="fas fa-money-bill-wave"></i> Pricing & Stock
                    </h4>
                    <table style="width: 100%;">
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d; width: 40%;">Purchase Price:</td>
                            <td style="padding: 0.5rem 0; font-weight: 500;">Rs. {{ number_format($item->purchase_price, 2) }}</td>
                        </tr>
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d;">Sale Price:</td>
                            <td style="padding: 0.5rem 0; font-weight: 500;">Rs. {{ number_format($item->sale_price, 2) }}</td>
                        </tr>
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d;">Profit Margin:</td>
                            <td style="padding: 0.5rem 0; color: #28a745; font-weight: 500;">
                                @php
                                    $margin = $item->purchase_price > 0 ? (($item->sale_price - $item->purchase_price) / $item->purchase_price) * 100 : 0;
                                @endphp
                                {{ number_format($margin, 2) }}%
                            </td>
                        </tr>
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d;">Opening Stock:</td>
                            <td style="padding: 0.5rem 0;">{{ number_format($item->opening_stock, 2) }} {{ $item->unit }}</td>
                        </tr>
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d;">Current Stock:</td>
                            <td style="padding: 0.5rem 0; font-weight: 700; font-size: 1.1rem; color: {{ $isLowStock ? '#dc3545' : 'var(--primary-color)' }};">
                                {{ number_format($item->current_stock, 2) }} {{ $item->unit }}
                            </td>
                        </tr>
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d;">Minimum Stock:</td>
                            <td style="padding: 0.5rem 0;">{{ number_format($item->minimum_stock, 2) }} {{ $item->unit }}</td>
                        </tr>
                        <tr>
                            <td style="padding: 0.5rem 0; color: #6c757d;">Stock Value:</td>
                            <td style="padding: 0.5rem 0; font-weight: 600;">Rs. {{ number_format($item->current_stock * $item->purchase_price, 2) }}</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>

        <!-- Recent Transactions -->
        <div class="form-row" style="margin-top: 1.5rem;">
            <div class="form-group" style="flex: 1;">
                <div style="border: 1px solid #dee2e6; border-radius: 8px; padding: 1rem;">
                    <h4 style="margin: 0 0 1rem 0; padding-bottom: 0.5rem; border-bottom: 1px solid #dee2e6;">
                        <i class="fas fa-shopping-cart"></i> Recent Purchases
                    </h4>
                    @if($item->purchaseItems && $item->purchaseItems->count() > 0)
                        <table style="width: 100%;">
                            <thead>
                                <tr>
                                    <th style="padding: 0.5rem; text-align: left;">Bill No</th>
                                    <th style="padding: 0.5rem; text-align: left;">Date</th>
                                    <th style="padding: 0.5rem; text-align: right;">Qty</th>
                                    <th style="padding: 0.5rem; text-align: right;">Rate</th>
                                    <th style="padding: 0.5rem; text-align: right;">Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($item->purchaseItems->take(10) as $purchaseItem)
                                    <tr>
                                        <td style="padding: 0.5rem;">
                                            <a href="{{ route('purchases.show', $purchaseItem->purchase) }}">{{ $purchaseItem->purchase->bill_no }}</a>
                                        </td>
                                        <td style="padding: 0.5rem;">{{ \Carbon\Carbon::parse($purchaseItem->purchase->date)->format('d M Y') }}</td>
                                        <td style="padding: 0.5rem; text-align: right;">{{ number_format($purchaseItem->quantity, 2) }}</td>
                                        <td style="padding: 0.5rem; text-align: right;">{{ number_format($purchaseItem->rate, 2) }}</td>
                                        <td style="padding: 0.5rem; text-align: right;">Rs. {{ number_format($purchaseItem->amount, 2) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    @else
                        <p style="text-align: center; color: #6c757d; margin: 2rem 0;">No purchases found for this item.</p>
                    @endif
                </div>
            </div>

            <div class="form-group" style="flex: 1;">
                <div style="border: 1px solid #dee2e6; border-radius: 8px; padding: 1rem;">
                    <h4 style="margin: 0 0 1rem 0; padding-bottom: 0.5rem; border-bottom: 1px solid #dee2e6;">
                        <i class="fas fa-shopping-bag"></i> Recent Sales
                    </h4>
                    @if($item->saleItems && $item->saleItems->count() > 0)
                        <table style="width: 100%;">
                            <thead>
                                <tr>
                                    <th style="padding: 0.5rem; text-align: left;">Bill No</th>
                                    <th style="padding: 0.5rem; text-align: left;">Date</th>
                                    <th style="padding: 0.5rem; text-align: right;">Qty</th>
                                    <th style="padding: 0.5rem; text-align: right;">Rate</th>
                                    <th style="padding: 0.5rem; text-align: right;">Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($item->saleItems->take(10) as $saleItem)
                                    <tr>
                                        <td style="padding: 0.5rem;">
                                            <a href="{{ route('sales.show', $saleItem->sale) }}">{{ $saleItem->sale->bill_no }}</a>
                                        </td>
                                        <td style="padding: 0.5rem;">{{ \Carbon\Carbon::parse($saleItem->sale->date)->format('d M Y') }}</td>
                                        <td style="padding: 0.5rem; text-align: right;">{{ number_format($saleItem->quantity, 2) }}</td>
                                        <td style="padding: 0.5rem; text-align: right;">{{ number_format($saleItem->rate, 2) }}</td>
                                        <td style="padding: 0.5rem; text-align: right;">Rs. {{ number_format($saleItem->amount, 2) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    @else
                        <p style="text-align: center; color: #6c757d; margin: 2rem 0;">No sales found for this item.</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
