@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-box"></i> Items / Products</h3>
        <a href="{{ route('items.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> New Item
        </a>
    </div>
    <div class="card-body">
        @if(session('success'))
            <div class="alert" style="background-color: #d4edda; border: 1px solid #c3e6cb; color: #155724; padding: 1rem; border-radius: 4px; margin-bottom: 1rem;">
                <i class="fas fa-check-circle"></i> {{ session('success') }}
            </div>
        @endif
        @if(session('error'))
            <div class="alert" style="background-color: #f8d7da; border: 1px solid #f5c6cb; color: #721c24; padding: 1rem; border-radius: 4px; margin-bottom: 1rem;">
                <i class="fas fa-exclamation-circle"></i> {{ session('error') }}
            </div>
        @endif

        <!-- Filters -->
        <form method="GET" action="{{ route('items.index') }}">
            <div class="form-row mb-4">
                <div class="form-group" style="flex: 1;">
                    <label class="form-label">Search</label>
                    <input type="text" class="form-control" name="search" value="{{ request('search') }}" placeholder="Search by code or name...">
                </div>
                <div class="form-group" style="flex: 0 0 150px;">
                    <label class="form-label">Product Type</label>
                    <select class="form-control" name="type" onchange="this.form.submit()">
                        <option value="">All</option>
                        @foreach($types as $key => $value)
                            <option value="{{ $key }}" {{ request('type') == $key ? 'selected' : '' }}>{{ $value }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="form-group" style="flex: 0 0 auto; display: flex; align-items: flex-end;">
                    <button type="submit" class="btn btn-outline" style="margin-right: 0.5rem;"><i class="fas fa-search"></i> Search</button>
                    <a href="{{ route('items.index') }}" class="btn btn-outline"><i class="fas fa-times"></i> Clear</a>
                </div>
            </div>
        </form>

        <!-- Summary Cards -->
        <div class="form-row mb-4">
            @php
                $rawItems = $items->where('type', 'raw');
                $finishItems = $items->where('type', 'finish');
                $lowStockItems = $items->filter(fn($i) => $i->current_stock <= $i->minimum_stock && $i->minimum_stock > 0);
            @endphp
            <div class="form-group" style="flex: 1;">
                <div style="background: linear-gradient(135deg, #fef3c7 0%, #fcd34d 100%); padding: 1rem; border-radius: 8px; text-align: center;">
                    <div style="font-size: 0.85rem; color: #92400e;">RAW Materials</div>
                    <div style="font-size: 1.5rem; font-weight: 700; color: #92400e;">{{ $rawItems->count() }}</div>
                </div>
            </div>
            <div class="form-group" style="flex: 1;">
                <div style="background: linear-gradient(135deg, #dcfce7 0%, #86efac 100%); padding: 1rem; border-radius: 8px; text-align: center;">
                    <div style="font-size: 0.85rem; color: #166534;">FINISH Products</div>
                    <div style="font-size: 1.5rem; font-weight: 700; color: #166534;">{{ $finishItems->count() }}</div>
                </div>
            </div>
            <div class="form-group" style="flex: 1;">
                <div style="background: linear-gradient(135deg, #f8d7da 0%, #f5c6cb 100%); padding: 1rem; border-radius: 8px; text-align: center;">
                    <div style="font-size: 0.85rem; color: #721c24;">Low Stock Items</div>
                    <div style="font-size: 1.5rem; font-weight: 700; color: #721c24;">{{ $lowStockItems->count() }}</div>
                </div>
            </div>
            <div class="form-group" style="flex: 1;">
                <div style="background: linear-gradient(135deg, #cce5ff 0%, #b8daff 100%); padding: 1rem; border-radius: 8px; text-align: center;">
                    <div style="font-size: 0.85rem; color: #004085;">Total Items</div>
                    <div style="font-size: 1.5rem; font-weight: 700; color: #004085;">{{ $items->count() }}</div>
                </div>
            </div>
        </div>

        <div class="table-responsive">
            <table>
                <thead>
                    <tr>
                        <th>Code</th>
                        <th>Item Name</th>
                        <th>Type</th>
                        <th>Unit</th>
                        <th class="text-right">Purchase Price</th>
                        <th class="text-right">Sale Price</th>
                        <th class="text-right">Stock</th>
                        <th class="text-center">Status</th>
                        <th class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($items as $item)
                        <tr>
                            <td><strong>{{ $item->code }}</strong></td>
                            <td>{{ $item->name }}</td>
                            <td>
                                <span style="background: {{ $item->type == 'finish' ? '#dcfce7' : '#fef3c7' }}; color: {{ $item->type == 'finish' ? '#166534' : '#92400e' }}; padding: 0.25rem 0.5rem; border-radius: 4px; font-size: 0.75rem; font-weight: 600;">
                                    {{ $types[$item->type] ?? strtoupper($item->type) }}
                                </span>
                            </td>
                            <td>{{ $item->unit }}</td>
                            <td class="text-right">Rs. {{ number_format($item->purchase_price, 2) }}</td>
                            <td class="text-right">Rs. {{ number_format($item->sale_price, 2) }}</td>
                            <td class="text-right" style="{{ $item->current_stock <= $item->minimum_stock && $item->minimum_stock > 0 ? 'color: #dc3545; font-weight: 600;' : '' }}">
                                {{ number_format($item->current_stock, 2) }} {{ $item->unit }}
                                @if($item->current_stock <= $item->minimum_stock && $item->minimum_stock > 0)
                                    <i class="fas fa-exclamation-triangle" style="color: #dc3545;" title="Low Stock"></i>
                                @endif
                            </td>
                            <td class="text-center">
                                @if($item->is_active)
                                    <span style="background-color: #28a745; color: white; padding: 0.2rem 0.5rem; border-radius: 4px; font-size: 0.7rem;">Active</span>
                                @else
                                    <span style="background-color: #6c757d; color: white; padding: 0.2rem 0.5rem; border-radius: 4px; font-size: 0.7rem;">Inactive</span>
                                @endif
                            </td>
                            <td class="text-center">
                                <a href="{{ route('items.show', $item) }}" class="btn btn-outline" style="padding: 0.25rem 0.5rem;" title="View">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="{{ route('items.edit', $item) }}" class="btn btn-outline" style="padding: 0.25rem 0.5rem;" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form action="{{ route('items.destroy', $item) }}" method="POST" style="display: inline;">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-outline" style="padding: 0.25rem 0.5rem; color: var(--danger-color);" onclick="return confirm('Are you sure you want to delete this item?')" title="Delete">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="9" class="text-center text-muted" style="padding: 3rem;">
                                <i class="fas fa-box-open" style="font-size: 3rem; display: block; margin-bottom: 1rem; opacity: 0.5;"></i>
                                <p style="margin: 0;">No items found. <a href="{{ route('items.create') }}">Create your first item</a></p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div style="margin-top: 1rem; display: flex; justify-content: space-between; align-items: center;">
            <span style="color: #6c757d;">Total: {{ $items->count() }} items</span>
        </div>
    </div>
</div>
@endsection
