@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-edit"></i> Edit Item: {{ $item->name }}</h3>
        <a href="{{ route('items.index') }}" class="btn btn-outline">
            <i class="fas fa-arrow-left"></i> Back
        </a>
    </div>
    <div class="card-body">
        @if($errors->any())
            <div style="background-color: #f8d7da; border: 1px solid #f5c6cb; color: #721c24; padding: 1rem; border-radius: 4px; margin-bottom: 1rem;">
                <strong><i class="fas fa-exclamation-triangle"></i> Please fix the following errors:</strong>
                <ul style="margin: 0.5rem 0 0 1.5rem;">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form action="{{ route('items.update', $item) }}" method="POST">
            @csrf
            @method('PUT')
            
            <div class="form-row">
                <div class="form-group" style="flex: 0 0 150px;">
                    <label class="form-label">Item Code</label>
                    <input type="text" class="form-control" value="{{ $item->code }}" readonly style="background-color: #e9ecef;">
                </div>

                <div class="form-group">
                    <label class="form-label" for="name">Item Name <span class="text-danger">*</span></label>
                    <input type="text" class="form-control @error('name') is-invalid @enderror" 
                           id="name" name="name" value="{{ old('name', $item->name) }}" 
                           placeholder="e.g., Cotton Waste Grade A" required>
                    @error('name')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group">
                    <label class="form-label" for="type">Product Type <span class="text-danger">*</span></label>
                    <select class="form-control @error('type') is-invalid @enderror" 
                            id="type" name="type" required>
                        @foreach($types as $key => $value)
                            <option value="{{ $key }}" {{ old('type', $item->type) == $key ? 'selected' : '' }}>{{ $value }}</option>
                        @endforeach
                    </select>
                    @error('type')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group">
                    <label class="form-label" for="unit">Unit <span class="text-danger">*</span></label>
                    <select class="form-control @error('unit') is-invalid @enderror" 
                            id="unit" name="unit" required>
                        <option value="">Select Unit</option>
                        @foreach($units as $unit)
                            <option value="{{ $unit }}" {{ old('unit', $item->unit) == $unit ? 'selected' : '' }}>
                                {{ $unit }}
                            </option>
                        @endforeach
                    </select>
                    @error('unit')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label class="form-label" for="purchase_price">Purchase Price</label>
                    <input type="number" class="form-control @error('purchase_price') is-invalid @enderror" 
                           id="purchase_price" name="purchase_price" 
                           value="{{ old('purchase_price', $item->purchase_price) }}" step="0.01" min="0">
                    @error('purchase_price')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group">
                    <label class="form-label" for="sale_price">Sale Price</label>
                    <input type="number" class="form-control @error('sale_price') is-invalid @enderror" 
                           id="sale_price" name="sale_price" 
                           value="{{ old('sale_price', $item->sale_price) }}" step="0.01" min="0">
                    @error('sale_price')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label class="form-label" for="opening_stock">Opening Stock</label>
                    <input type="number" class="form-control @error('opening_stock') is-invalid @enderror" 
                           id="opening_stock" name="opening_stock" 
                           value="{{ old('opening_stock', $item->opening_stock) }}" step="0.01" min="0">
                    @error('opening_stock')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group">
                    <label class="form-label" for="minimum_stock">Minimum Stock Level</label>
                    <input type="number" class="form-control @error('minimum_stock') is-invalid @enderror" 
                           id="minimum_stock" name="minimum_stock" 
                           value="{{ old('minimum_stock', $item->minimum_stock) }}" step="0.01" min="0" 
                           placeholder="Alert when stock falls below">
                    @error('minimum_stock')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label class="form-label" for="description">Description</label>
                    <input type="text" class="form-control @error('description') is-invalid @enderror" 
                           id="description" name="description" 
                           value="{{ old('description', $item->description) }}" 
                           placeholder="Optional description...">
                    @error('description')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group" style="flex: 0 0 auto;">
                    <label class="form-label" style="display: block; margin-bottom: 0.75rem;">&nbsp;</label>
                    <label style="display: flex; align-items: center; gap: 0.5rem; cursor: pointer;">
                        <input type="checkbox" name="is_active" value="1" 
                               {{ old('is_active', $item->is_active) ? 'checked' : '' }}
                               style="width: 18px; height: 18px;">
                        <span>Active</span>
                    </label>
                </div>
            </div>

            <div style="background-color: #f8f9fa; padding: 1rem; border-radius: 4px; margin-top: 1rem; margin-bottom: 1rem;">
                <div class="form-row" style="margin-bottom: 0;">
                    <div class="form-group" style="margin-bottom: 0;">
                        <label class="form-label" style="color: #6c757d;">Current Stock</label>
                        <div style="font-size: 1.5rem; font-weight: 700; color: {{ $item->current_stock <= $item->minimum_stock && $item->minimum_stock > 0 ? '#dc3545' : 'var(--primary-color)' }};">
                            {{ number_format($item->current_stock, 2) }} {{ $item->unit }}
                            @if($item->current_stock <= $item->minimum_stock && $item->minimum_stock > 0)
                                <i class="fas fa-exclamation-triangle" title="Low Stock"></i>
                            @endif
                        </div>
                    </div>
                    <div class="form-group" style="margin-bottom: 0;">
                        <label class="form-label" style="color: #6c757d;">Created At</label>
                        <div>{{ $item->created_at->format('d M Y, h:i A') }}</div>
                    </div>
                    <div class="form-group" style="margin-bottom: 0;">
                        <label class="form-label" style="color: #6c757d;">Last Updated</label>
                        <div>{{ $item->updated_at->format('d M Y, h:i A') }}</div>
                    </div>
                </div>
            </div>

            <div style="display: flex; gap: 0.5rem; margin-top: 1.5rem;">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Update Item
                </button>
                <a href="{{ route('items.show', $item) }}" class="btn btn-outline">
                    <i class="fas fa-eye"></i> View
                </a>
                <a href="{{ route('items.index') }}" class="btn btn-outline">
                    Cancel
                </a>
            </div>
        </form>
    </div>
</div>
@endsection
