@extends('layouts.app')

@section('content')
<!-- Company Header -->
<div class="card mb-4" style="background: linear-gradient(135deg, #10b981 0%, #059669 100%); color: white; border: none;">
    <div class="card-body" style="padding: 2rem;">
        <div style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 1rem;">
            <div>
                <h1 style="font-size: 2rem; font-weight: 700; margin-bottom: 0.5rem;">
                    {{ $company->name ?? 'Your Company Name' }}
                </h1>
                <p style="opacity: 0.9; margin: 0;">
                    <i class="fas fa-map-marker-alt"></i> {{ $company->address ?? 'Main Susan Road Madina Town' }}<br>
                    <i class="fas fa-phone"></i> {{ $company->phone ?? '0300-6638044' }}
                </p>
            </div>
            <div style="text-align: right;">
                <p style="font-size: 0.875rem; opacity: 0.9; margin: 0;">
                    <i class="fas fa-calendar-alt"></i> {{ now()->format('l, F d, Y') }}
                </p>
                <p style="font-size: 0.875rem; opacity: 0.9; margin: 0;">
                    Financial Year: {{ $financialYear ?? 'July 2025 - June 2026' }}
                </p>
            </div>
        </div>
    </div>
</div>

<!-- Stats Cards -->
<div class="stats-grid">
    <div class="stat-card">
        <div class="stat-icon blue">
            <i class="fas fa-shopping-cart"></i>
        </div>
        <div class="stat-content">
            <h3>Rs. {{ number_format($todayPurchase ?? 0) }}</h3>
            <p>Today's Purchase</p>
        </div>
    </div>
    <div class="stat-card">
        <div class="stat-icon green">
            <i class="fas fa-receipt"></i>
        </div>
        <div class="stat-content">
            <h3>Rs. {{ number_format($todaySale ?? 0) }}</h3>
            <p>Today's Sale</p>
        </div>
    </div>
    <div class="stat-card">
        <div class="stat-icon yellow">
            <i class="fas fa-money-bill-wave"></i>
        </div>
        <div class="stat-content">
            <h3>Rs. {{ number_format($cashBalance ?? 0) }}</h3>
            <p>Cash Balance</p>
        </div>
    </div>
    <div class="stat-card">
        <div class="stat-icon red">
            <i class="fas fa-university"></i>
        </div>
        <div class="stat-content">
            <h3>Rs. {{ number_format($bankBalance ?? 0) }}</h3>
            <p>Bank Balance</p>
        </div>
    </div>
</div>

<!-- Second Row Stats -->
<div class="stats-grid">
    <div class="stat-card">
        <div class="stat-icon green">
            <i class="fas fa-arrow-down"></i>
        </div>
        <div class="stat-content">
            <h3>Rs. {{ number_format($totalReceivable ?? 0) }}</h3>
            <p>Total Receivable</p>
        </div>
    </div>
    <div class="stat-card">
        <div class="stat-icon red">
            <i class="fas fa-arrow-up"></i>
        </div>
        <div class="stat-content">
            <h3>Rs. {{ number_format($totalPayable ?? 0) }}</h3>
            <p>Total Payable</p>
        </div>
    </div>
    <div class="stat-card">
        <div class="stat-icon blue">
            <i class="fas fa-warehouse"></i>
        </div>
        <div class="stat-content">
            <h3>Rs. {{ number_format($stockValue ?? 0) }}</h3>
            <p>Stock Value</p>
        </div>
    </div>
    <div class="stat-card">
        <div class="stat-icon yellow">
            <i class="fas fa-chart-line"></i>
        </div>
        <div class="stat-content">
            <h3>Rs. {{ number_format($monthlyProfit ?? 0) }}</h3>
            <p>Monthly Profit</p>
        </div>
    </div>
</div>

<div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(400px, 1fr)); gap: 1.5rem;">
    <!-- Recent Transactions -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title"><i class="fas fa-history"></i> Recent Transactions</h3>
            <a href="{{ route('reports.daily-book') }}" class="btn btn-outline" style="font-size: 0.8125rem;">
                View All
            </a>
        </div>
        <div class="card-body" style="padding: 0;">
            <div class="table-responsive">
                <table>
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Type</th>
                            <th>Party</th>
                            <th class="text-right">Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($recentTransactions ?? [] as $transaction)
                            <tr>
                                <td>{{ $transaction->date->format('d M') }}</td>
                                <td>
                                    @php
                                        $type = class_basename($transaction->transactionable_type ?? '');
                                    @endphp
                                    <span class="badge badge-{{ $type == 'Sale' ? 'success' : ($type == 'Purchase' ? 'primary' : 'warning') }}">
                                        {{ $type ?: 'Entry' }}
                                    </span>
                                </td>
                                <td>{{ $transaction->account->name ?? '-' }}</td>
                                <td class="text-right">Rs. {{ number_format($transaction->debit ?: $transaction->credit) }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="4" class="text-center text-muted" style="padding: 2rem;">
                                    <i class="fas fa-inbox" style="font-size: 2rem; display: block; margin-bottom: 0.5rem;"></i>
                                    No recent transactions
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title"><i class="fas fa-bolt"></i> Quick Actions</h3>
        </div>
        <div class="card-body">
            <div style="display: grid; grid-template-columns: repeat(2, 1fr); gap: 1rem;">
                <a href="{{ route('sales.create') }}" class="btn btn-success" style="padding: 1rem; justify-content: center;">
                    <i class="fas fa-receipt"></i> New Sale
                </a>
                <a href="{{ route('purchases.create') }}" class="btn btn-primary" style="padding: 1rem; justify-content: center;">
                    <i class="fas fa-shopping-cart"></i> New Purchase
                </a>
                <a href="{{ route('vouchers.credit.create') }}" class="btn btn-outline" style="padding: 1rem; justify-content: center; border-color: #22c55e; color: #22c55e;">
                    <i class="fas fa-plus-circle"></i> Credit Voucher
                </a>
                <a href="{{ route('vouchers.debit.create') }}" class="btn btn-outline" style="padding: 1rem; justify-content: center; border-color: #ef4444; color: #ef4444;">
                    <i class="fas fa-minus-circle"></i> Debit Voucher
                </a>
                <a href="{{ route('accounts.create') }}" class="btn btn-outline" style="padding: 1rem; justify-content: center;">
                    <i class="fas fa-user-plus"></i> New Account
                </a>
                <a href="{{ route('items.create') }}" class="btn btn-outline" style="padding: 1rem; justify-content: center;">
                    <i class="fas fa-box"></i> New Item
                </a>
            </div>
        </div>
    </div>
</div>

<div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(400px, 1fr)); gap: 1.5rem; margin-top: 1.5rem;">
    <!-- Low Stock Items -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title"><i class="fas fa-exclamation-triangle text-warning"></i> Low Stock Items</h3>
            <a href="{{ route('reports.stock') }}" class="btn btn-outline" style="font-size: 0.8125rem;">
                View Stock
            </a>
        </div>
        <div class="card-body" style="padding: 0;">
            <div class="table-responsive">
                <table>
                    <thead>
                        <tr>
                            <th>Item</th>
                            <th>Current Stock</th>
                            <th>Min Level</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($lowStockItems ?? [] as $item)
                            <tr>
                                <td>{{ $item->name }}</td>
                                <td class="text-danger">{{ $item->current_stock }} {{ $item->unit }}</td>
                                <td>{{ $item->min_stock }} {{ $item->unit }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="3" class="text-center text-muted" style="padding: 2rem;">
                                    <i class="fas fa-check-circle text-success" style="font-size: 2rem; display: block; margin-bottom: 0.5rem;"></i>
                                    All items are in stock
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Top Customers -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title"><i class="fas fa-users"></i> Top Customers</h3>
            <a href="{{ route('parties.sale') }}" class="btn btn-outline" style="font-size: 0.8125rem;">
                View All
            </a>
        </div>
        <div class="card-body" style="padding: 0;">
            <div class="table-responsive">
                <table>
                    <thead>
                        <tr>
                            <th>Customer</th>
                            <th class="text-right">Total Sales</th>
                            <th class="text-right">Balance</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($topCustomers ?? [] as $sale)
                            <tr>
                                <td>{{ $sale->party->name ?? 'Unknown' }}</td>
                                <td class="text-right">Rs. {{ number_format($sale->total) }}</td>
                                <td class="text-right">-</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="3" class="text-center text-muted" style="padding: 2rem;">
                                    <i class="fas fa-user-friends" style="font-size: 2rem; display: block; margin-bottom: 0.5rem;"></i>
                                    No customer data yet
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection
