@extends('layouts.app')

@section('title', 'Contract Report')

@section('content')
<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
    <h2 style="margin: 0; color: #333;">
        <i class="fas fa-file-contract"></i> Contract Report
    </h2>
    <a href="{{ route('contracts.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Back to Contracts
    </a>
</div>

<!-- Filters -->
<div style="background: white; padding: 15px; border-radius: 8px; margin-bottom: 20px; box-shadow: 0 1px 3px rgba(0,0,0,0.1);">
    <form method="GET" action="{{ route('contracts.report') }}" style="display: flex; gap: 15px; flex-wrap: wrap; align-items: end;">
        <div style="flex: 1; min-width: 150px;">
            <label style="display: block; margin-bottom: 5px; font-weight: 500; color: #555;">Type</label>
            <select name="type" class="form-control">
                <option value="">All Types</option>
                @foreach(App\Models\Contract::TYPES as $key => $label)
                    <option value="{{ $key }}" {{ request('type') == $key ? 'selected' : '' }}>{{ $label }}</option>
                @endforeach
            </select>
        </div>
        <div style="flex: 1; min-width: 150px;">
            <label style="display: block; margin-bottom: 5px; font-weight: 500; color: #555;">Status</label>
            <select name="status" class="form-control">
                <option value="">All Status</option>
                @foreach(App\Models\Contract::STATUSES as $key => $label)
                    <option value="{{ $key }}" {{ request('status') == $key ? 'selected' : '' }}>{{ $label }}</option>
                @endforeach
            </select>
        </div>
        <div style="flex: 1; min-width: 200px;">
            <label style="display: block; margin-bottom: 5px; font-weight: 500; color: #555;">Party</label>
            <select name="party_id" class="form-control">
                <option value="">All Parties</option>
                @foreach($parties as $party)
                    <option value="{{ $party->id }}" {{ request('party_id') == $party->id ? 'selected' : '' }}>{{ $party->name }}</option>
                @endforeach
            </select>
        </div>
        <div style="flex: 1; min-width: 150px;">
            <label style="display: block; margin-bottom: 5px; font-weight: 500; color: #555;">From Date</label>
            <input type="date" name="from_date" class="form-control" value="{{ request('from_date') }}">
        </div>
        <div style="flex: 1; min-width: 150px;">
            <label style="display: block; margin-bottom: 5px; font-weight: 500; color: #555;">To Date</label>
            <input type="date" name="to_date" class="form-control" value="{{ request('to_date') }}">
        </div>
        <div>
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-search"></i> Generate
            </button>
            <a href="{{ route('contracts.report') }}" class="btn btn-secondary">
                <i class="fas fa-times"></i> Clear
            </a>
        </div>
    </form>
</div>

<!-- Summary Cards -->
<div style="display: grid; grid-template-columns: repeat(6, 1fr); gap: 15px; margin-bottom: 20px;">
    <div style="background: linear-gradient(135deg, #667eea, #764ba2); color: white; padding: 15px; border-radius: 8px; text-align: center;">
        <div style="font-size: 24px; font-weight: bold;">{{ $summary['total_contracts'] }}</div>
        <div style="opacity: 0.9; font-size: 12px;">Total Contracts</div>
    </div>
    <div style="background: linear-gradient(135deg, #11998e, #38ef7d); color: white; padding: 15px; border-radius: 8px; text-align: center;">
        <div style="font-size: 24px; font-weight: bold;">{{ $summary['purchase_contracts'] }}</div>
        <div style="opacity: 0.9; font-size: 12px;">Purchase</div>
    </div>
    <div style="background: linear-gradient(135deg, #ee9ca7, #ffdde1); color: #333; padding: 15px; border-radius: 8px; text-align: center;">
        <div style="font-size: 24px; font-weight: bold;">{{ $summary['sale_contracts'] }}</div>
        <div style="opacity: 0.9; font-size: 12px;">Sale</div>
    </div>
    <div style="background: linear-gradient(135deg, #a8edea, #fed6e3); color: #333; padding: 15px; border-radius: 8px; text-align: center;">
        <div style="font-size: 18px; font-weight: bold;">{{ number_format($summary['total_value'], 0) }}</div>
        <div style="opacity: 0.9; font-size: 12px;">Total Value</div>
    </div>
    <div style="background: linear-gradient(135deg, #c3cfe2, #d5d5d5); color: #333; padding: 15px; border-radius: 8px; text-align: center;">
        <div style="font-size: 18px; font-weight: bold;">{{ number_format($summary['delivered_value'], 0) }}</div>
        <div style="opacity: 0.9; font-size: 12px;">Delivered</div>
    </div>
    <div style="background: linear-gradient(135deg, #ffecd2, #fcb69f); color: #333; padding: 15px; border-radius: 8px; text-align: center;">
        <div style="font-size: 18px; font-weight: bold;">{{ number_format($summary['pending_value'], 0) }}</div>
        <div style="opacity: 0.9; font-size: 12px;">Pending</div>
    </div>
</div>

<!-- Contracts Table -->
<div style="background: white; border-radius: 8px; box-shadow: 0 1px 3px rgba(0,0,0,0.1); overflow: hidden;">
    <table class="table" style="margin: 0;">
        <thead>
            <tr style="background: #f8f9fa;">
                <th>Contract No</th>
                <th>Party</th>
                <th>Type</th>
                <th>Item</th>
                <th>Period</th>
                <th style="text-align: right;">Contract Value</th>
                <th style="text-align: right;">Delivered</th>
                <th style="text-align: right;">Pending</th>
                <th style="text-align: center;">%</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            @forelse($contracts as $contract)
            <tr>
                <td>
                    <a href="{{ route('contracts.show', $contract) }}" style="font-weight: 500; color: #007bff;">
                        {{ $contract->contract_no }}
                    </a>
                </td>
                <td>{{ $contract->party->name ?? '-' }}</td>
                <td>
                    @if($contract->type == 'purchase')
                        <span style="background: #e3f2fd; color: #1565c0; padding: 2px 6px; border-radius: 4px; font-size: 11px;">Purchase</span>
                    @else
                        <span style="background: #e8f5e9; color: #2e7d32; padding: 2px 6px; border-radius: 4px; font-size: 11px;">Sale</span>
                    @endif
                </td>
                <td>{{ $contract->item->name ?? 'General' }}</td>
                <td style="font-size: 11px;">
                    {{ $contract->start_date->format('d/m/Y') }}<br>
                    <span style="color: #666;">to {{ $contract->end_date ? $contract->end_date->format('d/m/Y') : 'Open' }}</span>
                </td>
                <td style="text-align: right;">{{ number_format($contract->contract_value, 0) }}</td>
                <td style="text-align: right; color: #2e7d32;">{{ number_format($contract->delivered_value, 0) }}</td>
                <td style="text-align: right; color: #c62828;">{{ number_format($contract->pending_value, 0) }}</td>
                <td style="text-align: center;">
                    <div style="background: #eee; border-radius: 10px; height: 8px; width: 50px; display: inline-block; overflow: hidden;">
                        <div style="background: #4caf50; height: 100%; width: {{ $contract->completion_percentage }}%;"></div>
                    </div>
                    <div style="font-size: 10px;">{{ $contract->completion_percentage }}%</div>
                </td>
                <td>
                    @php
                        $statusColors = [
                            'draft' => 'background: #fafafa; color: #666;',
                            'active' => 'background: #e8f5e9; color: #2e7d32;',
                            'completed' => 'background: #e3f2fd; color: #1565c0;',
                            'cancelled' => 'background: #ffebee; color: #c62828;',
                        ];
                    @endphp
                    <span style="{{ $statusColors[$contract->status] ?? '' }} padding: 2px 6px; border-radius: 4px; font-size: 11px;">
                        {{ ucfirst($contract->status) }}
                    </span>
                </td>
            </tr>
            @empty
            <tr>
                <td colspan="10" style="text-align: center; padding: 40px; color: #666;">
                    No contracts found matching the criteria.
                </td>
            </tr>
            @endforelse
        </tbody>
        @if($contracts->count() > 0)
        <tfoot>
            <tr style="background: #f8f9fa; font-weight: bold;">
                <td colspan="5" style="text-align: right;">Totals:</td>
                <td style="text-align: right;">{{ number_format($summary['total_value'], 0) }}</td>
                <td style="text-align: right; color: #2e7d32;">{{ number_format($summary['delivered_value'], 0) }}</td>
                <td style="text-align: right; color: #c62828;">{{ number_format($summary['pending_value'], 0) }}</td>
                <td colspan="2"></td>
            </tr>
        </tfoot>
        @endif
    </table>
</div>
@endsection
