<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Contract - {{ $contract->contract_no }}</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            line-height: 1.5;
            color: #333;
            background: white;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            text-align: center;
            border-bottom: 2px solid #333;
            padding-bottom: 15px;
            margin-bottom: 20px;
        }
        .company-name {
            font-size: 24px;
            font-weight: bold;
            color: #1a5f7a;
        }
        .document-title {
            font-size: 18px;
            margin-top: 10px;
            background: #f5f5f5;
            padding: 8px;
        }
        .contract-info {
            display: flex;
            justify-content: space-between;
            margin-bottom: 20px;
        }
        .contract-info div {
            width: 48%;
        }
        .info-table {
            width: 100%;
            border-collapse: collapse;
        }
        .info-table td {
            padding: 5px 0;
            vertical-align: top;
        }
        .info-table td:first-child {
            color: #666;
            width: 40%;
        }
        .info-table td:last-child {
            font-weight: 500;
        }
        .section-title {
            background: #f5f5f5;
            padding: 8px 10px;
            font-weight: bold;
            margin: 20px 0 10px 0;
            border-left: 4px solid #1a5f7a;
        }
        .details-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        .details-table th,
        .details-table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        .details-table th {
            background: #f8f9fa;
            font-weight: 600;
        }
        .details-table .right {
            text-align: right;
        }
        .summary-box {
            background: #f8f9fa;
            padding: 15px;
            border: 1px solid #ddd;
            margin-top: 20px;
        }
        .summary-row {
            display: flex;
            justify-content: space-between;
            padding: 5px 0;
        }
        .summary-row.total {
            border-top: 2px solid #333;
            margin-top: 10px;
            padding-top: 10px;
            font-weight: bold;
            font-size: 14px;
        }
        .terms-section {
            background: #fff;
            border: 1px solid #ddd;
            padding: 15px;
            margin-top: 20px;
        }
        .signature-section {
            display: flex;
            justify-content: space-between;
            margin-top: 50px;
            padding-top: 20px;
        }
        .signature-box {
            width: 200px;
            text-align: center;
        }
        .signature-line {
            border-top: 1px solid #333;
            padding-top: 5px;
            margin-top: 40px;
        }
        .status-badge {
            display: inline-block;
            padding: 4px 12px;
            border-radius: 4px;
            font-size: 11px;
            text-transform: uppercase;
        }
        .status-active { background: #e8f5e9; color: #2e7d32; }
        .status-draft { background: #f5f5f5; color: #666; }
        .status-completed { background: #e3f2fd; color: #1565c0; }
        .status-cancelled { background: #ffebee; color: #c62828; }
        
        @media print {
            body { -webkit-print-color-adjust: exact; print-color-adjust: exact; }
            .container { max-width: 100%; }
            .no-print { display: none; }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="no-print" style="margin-bottom: 20px; text-align: right;">
            <button onclick="window.print()" style="padding: 10px 20px; cursor: pointer;">
                Print Contract
            </button>
            <button onclick="window.close()" style="padding: 10px 20px; cursor: pointer; margin-left: 10px;">
                Close
            </button>
        </div>

        <div class="header">
            <div class="company-name">USMAN BILAL Enterprises</div>
            <div style="color: #666;">Cotton Waste Processor & Dealer</div>
            <div class="document-title">
                {{ $contract->type == 'purchase' ? 'PURCHASE' : 'SALE' }} CONTRACT
            </div>
        </div>

        <div class="contract-info">
            <div>
                <table class="info-table">
                    <tr>
                        <td>Contract No:</td>
                        <td>{{ $contract->contract_no }}</td>
                    </tr>
                    <tr>
                        <td>Title:</td>
                        <td>{{ $contract->title }}</td>
                    </tr>
                    <tr>
                        <td>Start Date:</td>
                        <td>{{ $contract->start_date->format('d M, Y') }}</td>
                    </tr>
                    <tr>
                        <td>End Date:</td>
                        <td>{{ $contract->end_date ? $contract->end_date->format('d M, Y') : 'Open Ended' }}</td>
                    </tr>
                    <tr>
                        <td>Status:</td>
                        <td>
                            <span class="status-badge status-{{ $contract->status }}">
                                {{ ucfirst($contract->status) }}
                            </span>
                        </td>
                    </tr>
                </table>
            </div>
            <div>
                <table class="info-table">
                    <tr>
                        <td>{{ $contract->type == 'purchase' ? 'Supplier' : 'Customer' }}:</td>
                        <td>{{ $contract->party->name ?? '-' }}</td>
                    </tr>
                    <tr>
                        <td>Address:</td>
                        <td>{{ $contract->party->address ?? '-' }}</td>
                    </tr>
                    <tr>
                        <td>Phone:</td>
                        <td>{{ $contract->party->phone ?? '-' }}</td>
                    </tr>
                    <tr>
                        <td>NTN:</td>
                        <td>{{ $contract->party->ntn ?? '-' }}</td>
                    </tr>
                </table>
            </div>
        </div>

        <div class="section-title">Contract Details</div>
        <table class="details-table">
            <tr>
                <th style="width: 30%;">Description</th>
                <th class="right">Quantity</th>
                <th class="right">Unit</th>
                <th class="right">Rate</th>
                <th class="right">Amount</th>
            </tr>
            <tr>
                <td>{{ $contract->item->name ?? 'General Contract' }}</td>
                <td class="right">{{ number_format($contract->agreed_quantity, 2) }}</td>
                <td class="right">{{ ucfirst($contract->quantity_unit) }}</td>
                <td class="right">{{ number_format($contract->agreed_rate, 2) }}</td>
                <td class="right">{{ number_format($contract->contract_value, 2) }}</td>
            </tr>
        </table>

        <div class="summary-box">
            <div class="summary-row">
                <span>Total Contract Value:</span>
                <span><strong>Rs. {{ number_format($contract->contract_value, 2) }}</strong></span>
            </div>
            @if($contract->agent_commission_rate > 0)
            <div class="summary-row">
                <span>Agent Commission Rate:</span>
                <span>Rs. {{ number_format($contract->agent_commission_rate, 2) }} / unit</span>
            </div>
            @endif
            @if($contract->transport_rate > 0)
            <div class="summary-row">
                <span>Transport Rate:</span>
                <span>Rs. {{ number_format($contract->transport_rate, 2) }} / unit</span>
            </div>
            @endif
            <div class="summary-row" style="margin-top: 15px; padding-top: 10px; border-top: 1px solid #ddd;">
                <span>Delivered Quantity:</span>
                <span>{{ number_format($contract->delivered_quantity, 2) }} {{ $contract->quantity_unit }}</span>
            </div>
            <div class="summary-row">
                <span>Pending Quantity:</span>
                <span>{{ number_format($contract->pending_quantity, 2) }} {{ $contract->quantity_unit }}</span>
            </div>
        </div>

        @if($contract->terms)
        <div class="section-title">Terms & Conditions</div>
        <div class="terms-section">
            {!! nl2br(e($contract->terms)) !!}
        </div>
        @endif

        @if($contract->remarks)
        <div class="section-title">Remarks</div>
        <div class="terms-section">
            {{ $contract->remarks }}
        </div>
        @endif

        <div class="signature-section">
            <div class="signature-box">
                <div class="signature-line">Party Signature</div>
            </div>
            <div class="signature-box">
                <div class="signature-line">Authorized Signature</div>
            </div>
        </div>

        <div style="text-align: center; margin-top: 30px; color: #666; font-size: 10px;">
            This is a computer generated document. Printed on: {{ now()->format('d M, Y h:i A') }}
        </div>
    </div>
</body>
</html>
