@extends('layouts.guest')

@section('content')
<div class="auth-form-header">
    <h2>Reset Password</h2>
    <p>Enter your new password below</p>
</div>

@if($errors->any())
    <div class="alert alert-danger">
        <i class="fas fa-exclamation-circle"></i>
        <ul style="margin: 0; padding-left: 1.25rem;">
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

<form method="POST" action="{{ route('password.store') }}">
    @csrf

    <!-- Password Reset Token -->
    <input type="hidden" name="token" value="{{ $request->route('token') }}">

    <div class="form-group">
        <label class="form-label" for="email">Email Address</label>
        <div class="input-group">
            <i class="fas fa-envelope"></i>
            <input type="email" 
                   id="email" 
                   name="email" 
                   class="form-control" 
                   placeholder="Enter your email"
                   value="{{ old('email', $request->email) }}"
                   required 
                   autofocus>
        </div>
        @error('email')
            <span class="error-message">{{ $message }}</span>
        @enderror
    </div>

    <div class="form-group">
        <label class="form-label" for="password">New Password</label>
        <div class="input-group">
            <i class="fas fa-lock"></i>
            <input type="password" 
                   id="password" 
                   name="password" 
                   class="form-control" 
                   placeholder="Enter new password"
                   required>
        </div>
        @error('password')
            <span class="error-message">{{ $message }}</span>
        @enderror
    </div>

    <div class="form-group">
        <label class="form-label" for="password_confirmation">Confirm Password</label>
        <div class="input-group">
            <i class="fas fa-lock"></i>
            <input type="password" 
                   id="password_confirmation" 
                   name="password_confirmation" 
                   class="form-control" 
                   placeholder="Confirm new password"
                   required>
        </div>
    </div>

    <button type="submit" class="btn-login">
        <i class="fas fa-key"></i> Reset Password
    </button>
</form>

<div class="auth-footer">
    <p>Remember your password? <a href="{{ route('login') }}">Back to Login</a></p>
</div>
@endsection
