@extends('layouts.guest')

@section('content')
<div class="auth-form-header">
    <h2>Create Account</h2>
    <p>Register to start using AccSoft</p>
</div>

@if($errors->any())
    <div class="alert alert-danger">
        <i class="fas fa-exclamation-circle"></i>
        <ul style="margin: 0; padding-left: 1.25rem;">
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

<form method="POST" action="{{ route('register') }}">
    @csrf
    
    <div class="form-group">
        <label class="form-label" for="name">Full Name</label>
        <div class="input-group">
            <i class="fas fa-user"></i>
            <input type="text" 
                   id="name" 
                   name="name" 
                   class="form-control" 
                   placeholder="Enter your full name"
                   value="{{ old('name') }}"
                   required 
                   autofocus>
        </div>
        @error('name')
            <span class="error-message">{{ $message }}</span>
        @enderror
    </div>

    <div class="form-group">
        <label class="form-label" for="email">Email Address</label>
        <div class="input-group">
            <i class="fas fa-envelope"></i>
            <input type="email" 
                   id="email" 
                   name="email" 
                   class="form-control" 
                   placeholder="Enter your email"
                   value="{{ old('email') }}"
                   required>
        </div>
        @error('email')
            <span class="error-message">{{ $message }}</span>
        @enderror
    </div>

    <div class="form-group">
        <label class="form-label" for="password">Password</label>
        <div class="input-group">
            <i class="fas fa-lock"></i>
            <input type="password" 
                   id="password" 
                   name="password" 
                   class="form-control" 
                   placeholder="Create a password"
                   required>
        </div>
        @error('password')
            <span class="error-message">{{ $message }}</span>
        @enderror
    </div>

    <div class="form-group">
        <label class="form-label" for="password_confirmation">Confirm Password</label>
        <div class="input-group">
            <i class="fas fa-lock"></i>
            <input type="password" 
                   id="password_confirmation" 
                   name="password_confirmation" 
                   class="form-control" 
                   placeholder="Confirm your password"
                   required>
        </div>
    </div>

    <div class="form-check">
        <input type="checkbox" id="terms" name="terms" required>
        <label for="terms">I agree to the <a href="#" style="color: #667eea;">Terms & Conditions</a></label>
    </div>

    <button type="submit" class="btn-login">
        <i class="fas fa-user-plus"></i> Create Account
    </button>
</form>

<div class="auth-footer">
    <p>Already have an account? <a href="{{ route('login') }}">Sign In</a></p>
</div>
@endsection
