@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title"><i class="fas fa-plus-circle"></i> Create New Account</h3>
        <a href="{{ route('accounts.index') }}" class="btn btn-outline">
            <i class="fas fa-arrow-left"></i> Back
        </a>
    </div>
    <div class="card-body">
        @if($errors->any())
            <div style="background-color: #f8d7da; border: 1px solid #f5c6cb; color: #721c24; padding: 1rem; border-radius: 4px; margin-bottom: 1rem;">
                <strong><i class="fas fa-exclamation-triangle"></i> Please fix the following errors:</strong>
                <ul style="margin: 0.5rem 0 0 1.5rem;">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form action="{{ route('accounts.store') }}" method="POST">
            @csrf
            
            <div class="form-row">
                <div class="form-group">
                    <label class="form-label" for="type">Account Type <span class="text-danger">*</span></label>
                    <select class="form-control @error('type') is-invalid @enderror" 
                            id="type" name="type" required onchange="updateSubTypes()">
                        <option value="">Select Type</option>
                        @foreach($types as $key => $type)
                            <option value="{{ $key }}" {{ old('type') == $key ? 'selected' : '' }}>
                                {{ $type['label'] }}
                            </option>
                        @endforeach
                    </select>
                    @error('type')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group">
                    <label class="form-label" for="sub_type">Sub Type</label>
                    <select class="form-control @error('sub_type') is-invalid @enderror" 
                            id="sub_type" name="sub_type">
                        <option value="">Select Sub Type</option>
                    </select>
                    @error('sub_type')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label class="form-label" for="code">Account Code <span class="text-danger">*</span></label>
                    <input type="text" class="form-control @error('code') is-invalid @enderror" 
                           id="code" name="code" value="{{ old('code') }}" 
                           placeholder="e.g., 1001" required>
                    @error('code')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                    <small style="color: #6c757d;">Code will be auto-generated based on type if left empty</small>
                </div>

                <div class="form-group">
                    <label class="form-label" for="name">Account Name <span class="text-danger">*</span></label>
                    <input type="text" class="form-control @error('name') is-invalid @enderror" 
                           id="name" name="name" value="{{ old('name') }}" 
                           placeholder="e.g., Cash in Hand" required>
                    @error('name')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label class="form-label" for="parent_id">Parent Account</label>
                    <select class="form-control @error('parent_id') is-invalid @enderror" id="parent_id" name="parent_id">
                        <option value="">No Parent (Root Account)</option>
                        @foreach($parentAccounts as $parent)
                            <option value="{{ $parent->id }}" {{ old('parent_id') == $parent->id ? 'selected' : '' }}>
                                {{ $parent->code }} - {{ $parent->name }}
                            </option>
                        @endforeach
                    </select>
                    @error('parent_id')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group">
                    <label class="form-label" for="description">Description</label>
                    <input type="text" class="form-control" id="description" name="description" 
                           value="{{ old('description') }}" placeholder="Optional description...">
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label class="form-label" for="opening_balance">Opening Balance</label>
                    <input type="number" class="form-control @error('opening_balance') is-invalid @enderror" 
                           id="opening_balance" name="opening_balance" 
                           value="{{ old('opening_balance', 0) }}" step="0.01" min="0">
                    @error('opening_balance')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group">
                    <label class="form-label" for="opening_type">Balance Type</label>
                    <select class="form-control @error('opening_type') is-invalid @enderror" id="opening_type" name="opening_type">
                        <option value="debit" {{ old('opening_type', 'debit') == 'debit' ? 'selected' : '' }}>Debit (Dr)</option>
                        <option value="credit" {{ old('opening_type') == 'credit' ? 'selected' : '' }}>Credit (Cr)</option>
                    </select>
                    @error('opening_type')
                        <span class="error-message">{{ $message }}</span>
                    @enderror
                </div>
            </div>

            <div style="display: flex; gap: 0.5rem; margin-top: 1.5rem;">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Save Account
                </button>
                <a href="{{ route('accounts.index') }}" class="btn btn-outline">
                    Cancel
                </a>
            </div>
        </form>
    </div>
</div>

<script>
    const allSubTypes = @json($subTypes);

    function updateSubTypes() {
        const typeSelect = document.getElementById('type');
        const subTypeSelect = document.getElementById('sub_type');
        const selectedType = typeSelect.value;
        
        // Clear current options
        subTypeSelect.innerHTML = '<option value="">Select Sub Type</option>';
        
        if (selectedType && allSubTypes[selectedType]) {
            const subTypes = allSubTypes[selectedType];
            for (const [key, value] of Object.entries(subTypes)) {
                const option = document.createElement('option');
                option.value = key;
                option.textContent = value;
                subTypeSelect.appendChild(option);
            }
        }
    }

    // Initialize on page load
    document.addEventListener('DOMContentLoaded', function() {
        updateSubTypes();
        @if(old('sub_type'))
            document.getElementById('sub_type').value = '{{ old('sub_type') }}';
        @endif
    });
</script>
@endsection
