<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class AdminUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        User::updateOrCreate(
            ['email' => 'admin@accsoft.com'],
            [
                'name' => 'Administrator',
                'email' => 'admin@accsoft.com',
                'password' => Hash::make('admin123'),
                'email_verified_at' => now(),
            ]
        );

        // Create a demo user as well
        User::updateOrCreate(
            ['email' => 'demo@accsoft.com'],
            [
                'name' => 'Demo User',
                'email' => 'demo@accsoft.com',
                'password' => Hash::make('demo123'),
                'email_verified_at' => now(),
            ]
        );

        $this->command->info('Admin users seeded successfully!');
        $this->command->info('Admin: admin@accsoft.com / admin123');
        $this->command->info('Demo: demo@accsoft.com / demo123');
    }
}
