<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vouchers', function (Blueprint $table) {
            $table->id();
            $table->string('voucher_no', 50)->unique();
            $table->enum('type', ['credit', 'debit', 'journal']); // CR=Receipt, DR=Payment, JV=Journal
            $table->date('date');
            $table->string('reference')->nullable(); // Cheque No, Invoice No, etc.
            $table->enum('payment_mode', ['cash', 'cheque', 'online', 'dd'])->nullable();
            $table->foreignId('account_id')->nullable()->constrained('accounts')->onDelete('set null'); // For CR/DR: Cash/Bank account
            $table->decimal('total_amount', 15, 2)->default(0);
            $table->text('narration')->nullable();
            $table->enum('status', ['draft', 'confirmed', 'cancelled'])->default('confirmed');
            $table->foreignId('created_by')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamps();
            $table->softDeletes();
            
            $table->index('type');
            $table->index('date');
            $table->index('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vouchers');
    }
};
