<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ProductionItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'production_id',
        'item_id',
        'type',
        'quantity',
        'rate',
        'amount',
    ];

    protected $casts = [
        'quantity' => 'decimal:3',
        'rate' => 'decimal:2',
        'amount' => 'decimal:2',
    ];

    /**
     * Types
     */
    public const TYPES = [
        'input' => 'Raw Material (Input)',
        'output' => 'Finished Goods (Output)',
        'wastage' => 'Wastage',
    ];

    /**
     * Production relationship
     */
    public function production(): BelongsTo
    {
        return $this->belongsTo(Production::class);
    }

    /**
     * Item relationship
     */
    public function item(): BelongsTo
    {
        return $this->belongsTo(Item::class);
    }
}
