<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\View\View;

class SettingController extends Controller
{
    /**
     * Display settings index.
     */
    public function index(): View
    {
        return view('settings.index');
    }

    /**
     * Display company settings.
     */
    public function company(): View
    {
        $company = (object) [
            'name' => config('accsoft.company_name', ''),
            'address' => config('accsoft.company_address', ''),
            'phone' => config('accsoft.company_phone', ''),
            'email' => config('accsoft.company_email', ''),
            'website' => config('accsoft.company_website', ''),
            'logo' => config('accsoft.company_logo', ''),
        ];
        return view('settings.company', compact('company'));
    }

    /**
     * Update company settings.
     */
    public function updateCompany(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'address' => 'nullable|string|max:500',
            'phone' => 'nullable|string|max:50',
            'email' => 'nullable|email|max:255',
            'website' => 'nullable|url|max:255',
            'logo' => 'nullable|image|max:2048',
        ]);

        // Save settings logic will be implemented here
        
        return redirect()->route('settings.company')
            ->with('success', 'Company settings updated successfully.');
    }

    /**
     * Display financial year settings.
     */
    public function financialYear(): View
    {
        $financialYear = (object) [
            'start_date' => config('accsoft.financial_year_start', now()->startOfYear()->format('Y-m-d')),
            'end_date' => config('accsoft.financial_year_end', now()->endOfYear()->format('Y-m-d')),
        ];
        return view('settings.financial-year', compact('financialYear'));
    }

    /**
     * Update financial year settings.
     */
    public function updateFinancialYear(Request $request)
    {
        $request->validate([
            'start_date' => 'required|date',
            'end_date' => 'required|date|after:start_date',
        ]);

        // Save settings logic will be implemented here
        
        return redirect()->route('settings.financial-year')
            ->with('success', 'Financial year settings updated successfully.');
    }
}
